/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import org.acme.DomainTest;
import org.cotrix.domain.memory.IdentifiedMS;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Status;
import org.junit.Assert;
import org.junit.Test;

public class IdentifiedTest
extends DomainTest {
    @Test
    public void newEntitiesHaveIdentifiers() {
        Identified.Abstract e = this.like(new MyEntity((Identified.State)new IdentifiedMS()));
        Assert.assertNotNull((Object)e.id());
        Assert.assertNull((Object)e.status());
    }

    @Test
    public void identifierAndStatusMustBeValid() {
        try {
            this.like(new MyEntity((Identified.State)new IdentifiedMS(null, Status.MODIFIED)));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.like(new MyEntity((Identified.State)new IdentifiedMS("id", null)));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void changesetsCannotBeNull() {
        MyEntity e = new MyEntity((Identified.State)new IdentifiedMS());
        try {
            e.update(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void changesetsCannotBeNew() {
        MyEntity e = new MyEntity((Identified.State)new IdentifiedMS());
        MyEntity newEntity = new MyEntity((Identified.State)new IdentifiedMS());
        try {
            e.update(newEntity);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void changesetsMustMatchIdentifiers() {
        MyEntity e = new MyEntity((Identified.State)new IdentifiedMS());
        try {
            e.update(null);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        MyEntity changeset = new MyEntity((Identified.State)new IdentifiedMS("another", Status.MODIFIED));
        try {
            e.update(changeset);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void changesetsCannotBeUpdated() {
        MyEntity changeset = new MyEntity((Identified.State)new IdentifiedMS("someid", Status.MODIFIED){});
        try {
            changeset.update(changeset);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void changesetsCannotBeDirectlyDeleted() {
        MyEntity e = new MyEntity((Identified.State)new IdentifiedMS());
        MyEntity changeset = new MyEntity((Identified.State)new IdentifiedMS("someid", Status.DELETED));
        try {
            e.update(changeset);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static class MyEntity
    extends Identified.Abstract<MyEntity, Identified.State> {
        public MyEntity(Identified.State state) {
            super(state);
        }
    }
}

