/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.memory.CodelistMS;
import org.cotrix.domain.trait.Status;
import org.cotrix.domain.version.DefaultVersion;
import org.cotrix.domain.version.Version;
import org.junit.Assert;
import org.junit.Test;

public class CodelistTest
extends DomainTest {
    @Test
    public void codelistCanBeFluentlyConstructed() {
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).build();
        Assert.assertEquals((Object)Fixture.name, (Object)list.name());
        Attribute a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).build();
        list = (Codelist)((CodelistGrammar.FinalClause)((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).attributes(new Attribute[]{a})).build();
        Assert.assertTrue((boolean)list.attributes().contains((Object)a));
        Code c = (Code)((CodeGrammar.SecondClause)Codes.code().name(Fixture.name)).build();
        list = (Codelist)((CodelistGrammar.ThirdClause)((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).with((Object[])new Code[]{c})).build();
        Assert.assertTrue((boolean)list.codes().contains((Object)c));
        list = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).version("1.0").build();
        Assert.assertEquals((Object)"1.0", (Object)list.version());
        ((CodelistGrammar.FinalClause)((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).attributes(new Attribute[]{a})).version("1").build();
        ((CodelistGrammar.ThirdClause)((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).with((Object[])new Code[]{c})).version("1").build();
        ((CodelistGrammar.FinalClause)((CodelistGrammar.ThirdClause)((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).with((Object[])new Code[]{c})).attributes(new Attribute[]{a})).build();
        ((CodelistGrammar.FinalClause)((CodelistGrammar.ThirdClause)((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).with((Object[])new Code[]{c})).attributes(new Attribute[]{a})).version("1").build();
    }

    @Test
    public void changesetCanBeFluentlyConstructed() {
        Code c = (Code)((CodeGrammar.SecondClause)Codes.code().name("name")).build();
        Attribute a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).build();
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)Codes.modifyCodelist((String)"1").name(Fixture.name)).build();
        list = (Codelist)((CodelistGrammar.FinalClause)Codes.modifyCodelist((String)"1").attributes(new Attribute[]{a})).build();
        list = (Codelist)((CodelistGrammar.ThirdClause)Codes.modifyCodelist((String)"1").with((Object[])new Code[]{c})).build();
        list = (Codelist)((CodelistGrammar.FinalClause)((CodelistGrammar.ThirdClause)Codes.modifyCodelist((String)"1").with((Object[])new Code[]{c})).attributes(new Attribute[]{a})).build();
        Assert.assertEquals((Object)Status.MODIFIED, (Object)((Codelist.Private)list).status());
    }

    @Test
    public void cloned() {
        Attribute a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build();
        Code c = (Code)((CodeGrammar.FinalClause)((CodeGrammar.SecondClause)Codes.code().name(Fixture.name)).attributes(new Attribute[]{a})).build();
        Codelist list = (Codelist)this.like(((CodelistGrammar.ThirdClause)((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).with((Object[])new Code[]{c})).build());
        Codelist.State state = (Codelist.State)Codes.reveal((Codelist)list).state();
        CodelistMS clone = new CodelistMS(state);
        Assert.assertEquals((Object)clone, (Object)state);
        Assert.assertFalse((boolean)clone.id().equals(state.id()));
    }

    @Test
    public void versioned() {
        Attribute a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).value(Fixture.value).ofType(Fixture.type).in(Fixture.language).build();
        Code c = (Code)((CodeGrammar.FinalClause)((CodeGrammar.SecondClause)Codes.code().name(Fixture.name)).attributes(new Attribute[]{a})).build();
        Codelist list = (Codelist)this.like(((CodelistGrammar.ThirdClause)((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).with((Object[])new Code[]{c})).version("1").build());
        Codelist versioned = (Codelist)Codes.reveal((Codelist)list).bump("2");
        Assert.assertEquals((Object)"2", (Object)versioned.version());
        Codelist.State state = (Codelist.State)Codes.reveal((Codelist)list).state();
        state.version((Version)new DefaultVersion("2"));
        CodelistMS clone = new CodelistMS(state);
        Assert.assertEquals((Object)clone, (Object)state);
        Assert.assertFalse((boolean)clone.id().equals(state.id()));
    }

    @Test(expected=IllegalStateException.class)
    public void versionsMustBeConsistent() {
        Codelist list = (Codelist)this.like(((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).version("2").build());
        Codes.reveal((Codelist)list).bump("1.3");
    }

    @Test
    public void changeCode() {
        Codelist list = (Codelist)this.like(((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).build());
        Codelist changeset = (Codelist)((CodelistGrammar.SecondClause)Codes.modifyCodelist((String)list.id()).name(Fixture.name2)).build();
        Codes.reveal((Codelist)list).update(Codes.reveal((Codelist)changeset));
        Assert.assertEquals((Object)Fixture.name2, (Object)list.name());
    }

    @Test
    public void addCode() {
        Codelist list = (Codelist)this.like(((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).build());
        Code added = (Code)((CodeGrammar.SecondClause)Codes.code().name(Fixture.name)).build();
        Assert.assertFalse((boolean)list.codes().contains((Object)added));
        Codelist changeset = (Codelist)((CodelistGrammar.ThirdClause)Codes.modifyCodelist((String)list.id()).with((Object[])new Code[]{added})).build();
        Codes.reveal((Codelist)list).update(Codes.reveal((Codelist)changeset));
        Assert.assertTrue((boolean)list.codes().contains(Fixture.name));
    }

    @Test
    public void removeCode() {
        Code c = (Code)((CodeGrammar.SecondClause)Codes.code().name(Fixture.name)).build();
        Codelist list = (Codelist)this.like(((CodelistGrammar.ThirdClause)((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).with((Object[])new Code[]{c})).build());
        Assert.assertTrue((boolean)list.codes().contains((Object)c));
        Code deleted = Codes.deleteCode((String)c.id());
        Codelist changeset = (Codelist)((CodelistGrammar.ThirdClause)Codes.modifyCodelist((String)list.id()).with((Object[])new Code[]{deleted})).build();
        Codes.reveal((Codelist)list).update(Codes.reveal((Codelist)changeset));
        Assert.assertFalse((boolean)list.codes().contains((Object)c));
    }
}

