/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.Definition;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.links.AttributeLink;
import org.cotrix.domain.links.LinkValueType;
import org.cotrix.domain.utils.AttributeTemplate;
import org.cotrix.domain.utils.Constants;

public class Fingerprint {
    private final Map<QName, Map<QName, Set<String>>> data = new HashMap<QName, Map<QName, Set<String>>>();

    public Fingerprint addAttributes(Iterable<? extends Attribute> attributes) {
        for (Attribute attribute : attributes) {
            if (attribute.is(Constants.SYSTEM_TYPE)) continue;
            Fingerprint.addTo(this.typesFor(attribute.name()), attribute.type(), attribute.language());
        }
        return this;
    }

    public Fingerprint addDefinitions(Iterable<? extends Definition> definitions) {
        for (Definition definition : definitions) {
            if (definition.is(Constants.SYSTEM_TYPE)) continue;
            Fingerprint.addTo(this.typesFor(definition.name()), definition.type(), definition.language());
        }
        return this;
    }

    public Fingerprint addLinks(Iterable<? extends CodelistLink> links) {
        for (CodelistLink codelistLink : links) {
            LinkValueType type = codelistLink.valueType();
            if (!(type instanceof AttributeLink)) continue;
            Map<QName, Set<String>> types = this.typesFor(codelistLink.name());
            AttributeTemplate template = ((AttributeLink)type).template();
            Fingerprint.addTo(types, template.type(), template.language());
        }
        return this;
    }

    public Map<QName, Set<String>> typesFor(QName name) {
        Map<QName, Set<String>> types = this.data.get(name);
        if (types == null) {
            types = new HashMap<QName, Set<String>>();
            this.data.put(name, types);
        }
        return types;
    }

    public Collection<QName> names() {
        return this.data.keySet();
    }

    public Collection<String> languagesFor(QName name, QName type) {
        if (this.data.containsKey(name) && this.data.get(name).containsKey(type)) {
            return this.typesFor(name).get(type);
        }
        return Collections.emptySet();
    }

    private static void addTo(Map<QName, Set<String>> types, QName type, String language) {
        Set<String> langForType = types.get(type);
        if (langForType == null) {
            langForType = new HashSet<String>();
            types.put(type, langForType);
        }
        if (language != null) {
            langForType.add(language);
        }
    }
}

