/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.utils.Constants;

public class CodelistSummary {
    private final QName name;
    private final int size;
    private final Collection<String> allLanguages = new ArrayList<String>();
    private final Collection<QName> allTypes = new ArrayList<QName>();
    private final Collection<QName> allNames = new ArrayList<QName>();
    private final Map<QName, Map<QName, Set<String>>> fingerprint;
    private final Map<QName, Map<QName, Set<String>>> globalFingerprint;

    public CodelistSummary(QName name, int size, Collection<Attribute> attributes, Map<QName, Map<QName, Set<String>>> fingerprint) {
        this.name = name;
        this.size = size;
        this.fingerprint = fingerprint;
        this.globalFingerprint = new HashMap<QName, Map<QName, Set<String>>>();
        CodelistSummary.addToFingerprint(this.globalFingerprint, attributes);
        for (QName n : fingerprint.keySet()) {
            this.allNames.add(n);
            for (Map<QName, Set<String>> typeMap : fingerprint.values()) {
                this.allTypes.addAll(typeMap.keySet());
                for (Set<String> ls : typeMap.values()) {
                    this.allLanguages.addAll(ls);
                }
            }
        }
        for (QName n : this.globalFingerprint.keySet()) {
            this.allNames.add(n);
            for (Map<QName, Set<String>> typeMap : this.globalFingerprint.values()) {
                this.allTypes.addAll(typeMap.keySet());
                for (Set<String> ls : typeMap.values()) {
                    this.allLanguages.addAll(ls);
                }
            }
        }
    }

    public QName name() {
        return this.name;
    }

    public int size() {
        return this.size;
    }

    public Collection<String> allLanguages() {
        return this.allLanguages;
    }

    public Collection<QName> allTypes() {
        return this.allTypes;
    }

    public Collection<QName> allNames() {
        return this.allNames;
    }

    public Collection<String> codeLanguagesFor(QName name, QName type) {
        if (this.fingerprint.containsKey(name) && this.fingerprint.get(name).containsKey(type)) {
            return this.fingerprint.get(name).get(type);
        }
        return Collections.emptySet();
    }

    public Collection<QName> allTypesFor(QName name) {
        HashSet<QName> values = new HashSet<QName>();
        Map<QName, Set<String>> typeMap = this.globalFingerprint.get(name);
        if (typeMap != null) {
            values.addAll(typeMap.keySet());
        }
        if ((typeMap = this.fingerprint.get(name)) != null) {
            values.addAll(typeMap.keySet());
        }
        return values;
    }

    public Collection<String> allLanguagesFor(QName name, QName type) {
        HashSet<String> values = new HashSet<String>();
        if (this.globalFingerprint.containsKey(name) && this.globalFingerprint.get(name).containsKey(type)) {
            values.addAll((Collection<String>)this.globalFingerprint.get(name).get(type));
        }
        if (this.fingerprint.containsKey(name) && this.fingerprint.get(name).containsKey(type)) {
            values.addAll((Collection<String>)this.fingerprint.get(name).get(type));
        }
        return values;
    }

    public Collection<QName> codeNames() {
        return this.fingerprint.keySet();
    }

    public Collection<QName> codeTypesFor(QName name) {
        return this.fingerprint.get(name).keySet();
    }

    public static void addToFingerprint(Map<QName, Map<QName, Set<String>>> fingerprint, Iterable<? extends Attribute> attributes) {
        for (Attribute attribute : attributes) {
            CodelistSummary.addAttributeToFingerprint(fingerprint, attribute);
        }
    }

    private static void addAttributeToFingerprint(Map<QName, Map<QName, Set<String>>> fingerprint, Attribute a) {
        Set<String> langForType;
        if (a.type().equals(Constants.SYSTEM_TYPE)) {
            return;
        }
        Map<QName, Set<String>> typeForAttr = fingerprint.get(a.name());
        if (typeForAttr == null) {
            typeForAttr = new HashMap<QName, Set<String>>();
            fingerprint.put(a.name(), typeForAttr);
        }
        if ((langForType = typeForAttr.get(a.type())) == null) {
            langForType = new HashSet<String>();
            typeForAttr.put(a.type(), langForType);
        }
        if (a.language() != null) {
            langForType.add(a.language());
        }
    }
}

