/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.domain;

import javax.xml.namespace.QName;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.attributes.CommonDefinition;
import org.cotrix.domain.attributes.Facet;
import org.cotrix.domain.common.Range;
import org.cotrix.domain.trait.Described;
import org.cotrix.domain.values.ValueType;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoDescribed;
import org.cotrix.neo.domain.utils.NeoStateFactory;
import org.neo4j.graphdb.Node;

public class NeoAttributeDefinition
extends NeoDescribed
implements AttributeDefinition.Bean {
    public static final NeoStateFactory<AttributeDefinition.Bean> factory = new NeoStateFactory<AttributeDefinition.Bean>(){

        @Override
        public AttributeDefinition.Bean beanFrom(Node node) {
            return new NeoAttributeDefinition(node);
        }

        @Override
        public Node nodeFrom(AttributeDefinition.Bean state) {
            return new NeoAttributeDefinition(state).node();
        }
    };

    public NeoAttributeDefinition(Node node) {
        super(node);
    }

    public NeoAttributeDefinition(AttributeDefinition.Bean state) {
        super(Constants.NodeType.ATTRDEF, (Described.Bean)state);
        this.type(state.type());
        this.language(state.language());
        this.valueType(state.valueType());
        this.range(state.range());
        this.shared(state.isShared());
    }

    public boolean isShared() {
        return (Boolean)this.node().getProperty("shared", (Object)true);
    }

    void shared(boolean flag) {
        if (!flag) {
            this.node().setProperty("shared", (Object)flag);
        }
    }

    public QName type() {
        String val = (String)this.node().getProperty("type", null);
        return val == null ? null : QName.valueOf(val);
    }

    public void type(QName type) {
        if (type == null) {
            this.node().removeProperty("type");
        } else {
            this.node().setProperty("type", (Object)type.toString());
        }
    }

    public boolean is(QName name) {
        return this.type().equals(name);
    }

    public boolean is(Facet facet) {
        return !CommonDefinition.isCommon((QName)this.qname()) || CommonDefinition.isCommon((QName)this.qname(), (Facet)facet);
    }

    public String language() {
        return (String)this.node().getProperty("lang", null);
    }

    public void language(String language) {
        if (language == null) {
            this.node().removeProperty("lang");
        } else {
            this.node().setProperty("lang", (Object)language);
        }
    }

    public ValueType valueType() {
        return (ValueType)CommonUtils.binder().fromXML((String)this.node().getProperty("vtype"));
    }

    public void valueType(ValueType state) {
        this.node().setProperty("vtype", (Object)CommonUtils.binder().toXML((Object)state));
    }

    public Range range() {
        return (Range)CommonUtils.binder().fromXML((String)this.node().getProperty("range"));
    }

    public void range(Range type) {
        this.node().setProperty("range", (Object)CommonUtils.binder().toXML((Object)type));
    }

    public AttributeDefinition.Private entity() {
        return new AttributeDefinition.Private((AttributeDefinition.Bean)this);
    }
}

