/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.domain.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.cotrix.common.Utils;
import org.cotrix.domain.common.NamedStateContainer;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;
import org.cotrix.neo.NeoUtils;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.utils.NeoRelationshipIterator;
import org.cotrix.neo.domain.utils.NeoStateFactory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class NeoContainer<S extends Identified.State & Named.State>
implements NamedStateContainer<S> {
    private final Node node;
    private final Constants.Relations type;
    private final NeoStateFactory<S> factory;

    public NeoContainer(Node node, Constants.Relations type, NeoStateFactory<S> mapper) {
        this.node = node;
        this.type = type;
        this.factory = mapper;
    }

    public Iterator<S> iterator() {
        return new NeoRelationshipIterator<S>(this.node.getRelationships(Direction.OUTGOING, new RelationshipType[]{this.type}).iterator(), this.factory);
    }

    public int size() {
        return Utils.count((Iterable)this.node.getRelationships(Direction.OUTGOING, new RelationshipType[]{this.type}));
    }

    public void remove(String id) {
        for (Relationship rel : this.node.getRelationships(Direction.OUTGOING, new RelationshipType[]{this.type})) {
            Node n = rel.getEndNode();
            if (!id.equals(n.getProperty("id"))) continue;
            NeoUtils.removeNode(n);
            break;
        }
    }

    public boolean contains(Identified.State element) {
        return this.contains(element.id());
    }

    public boolean contains(String id) {
        for (Node n : this.nodes()) {
            if (!id.equals(n.getProperty("id"))) continue;
            return true;
        }
        return false;
    }

    public void add(S element) {
        this.node.createRelationshipTo(this.factory.nodeFrom(element), (RelationshipType)this.type);
    }

    public Collection<S> get(Collection<String> ids) {
        ArrayList matches = new ArrayList();
        ArrayList<String> idCopy = new ArrayList<String>(ids);
        for (Node n : this.nodes()) {
            Object nodeId = n.getProperty("id");
            if (!idCopy.contains(nodeId)) continue;
            matches.add(this.factory.beanFrom(n));
            idCopy.remove(nodeId);
            if (!idCopy.isEmpty()) continue;
            break;
        }
        return matches;
    }

    public boolean contains(QName name) {
        for (Node n : this.nodes()) {
            if (!name.equals(((Named.State)((Identified.State)this.factory.beanFrom(n))).name())) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Named named) {
        return this.contains(named.name());
    }

    public Collection<S> getAll(QName name) {
        ArrayList matches = new ArrayList();
        for (Node n : this.nodes()) {
            if (!name.equals(((Named.State)((Identified.State)this.factory.beanFrom(n))).name())) continue;
            matches.add(this.factory.beanFrom(n));
        }
        return matches;
    }

    public S lookup(QName name) throws IllegalStateException {
        Collection<S> matches = this.getAll(name);
        if (matches.size() == 1) {
            return (S)((Identified.State)matches.iterator().next());
        }
        throw new IllegalStateException("zero or more than one element with name " + name);
    }

    public S lookup(Named named) throws IllegalStateException {
        return this.lookup(named.name());
    }

    private Iterable<Node> nodes() {
        return new Nodes(this.node.getRelationships(Direction.OUTGOING, new RelationshipType[]{this.type}));
    }

    private class Nodes
    implements Iterable<Node> {
        private final Iterable<Relationship> elements;

        public Nodes(Iterable<Relationship> elements) {
            this.elements = elements;
        }

        @Override
        public Iterator<Node> iterator() {
            final Iterator<Relationship> it = this.elements.iterator();
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Node next() {
                    return ((Relationship)it.next()).getEndNode();
                }

                @Override
                public void remove() {
                    ((Relationship)it.next()).delete();
                }
            };
        }
    }
}

