/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.repository;

import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.neo.NeoNodeFactory;
import org.cotrix.neo.NeoUtils;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoCodelist;
import org.cotrix.neo.repository.NeoCodelistQueries;
import org.cotrix.repository.CodelistRepository;
import org.cotrix.repository.spi.StateRepository;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;

@ApplicationScoped
@Alternative
@Priority(value=1000)
public class NeoCodelistRepository
implements StateRepository<Codelist.State> {
    @Inject
    private GraphDatabaseService store;
    @Inject
    private NeoCodelistQueries queries;

    public void add(Codelist.State list) {
        new NeoCodelist(list);
    }

    public boolean contains(String id) {
        return NeoNodeFactory.node(Constants.NodeType.CODELIST, id) != null;
    }

    public Codelist.State lookup(String id) {
        Node node = NeoNodeFactory.node(Constants.NodeType.CODELIST, id);
        return node == null ? null : new NeoCodelist(node);
    }

    public void remove(String id) {
        try {
            NeoUtils.removeEntityNode(NeoNodeFactory.node(Constants.NodeType.CODELIST, id));
        }
        catch (IllegalStateException e) {
            throw new CodelistRepository.UnremovableCodelistException("cannot remove codelist: other codelists link to it", (Exception)e);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot remove codelist", e);
        }
    }

    public int size() {
        return (Integer)this.queries.repositorySize(Constants.NodeType.CODELIST).execute();
    }
}

