/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.domain;

import javax.xml.namespace.QName;
import org.cotrix.domain.attributes.Definition;
import org.cotrix.domain.common.Range;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.values.ValueType;
import org.cotrix.neo.NeoUtils;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoIdentified;
import org.cotrix.neo.domain.utils.NeoStateFactory;
import org.neo4j.graphdb.Node;

public class NeoDefinition
extends NeoIdentified
implements Definition.State {
    public static final NeoStateFactory<Definition.State> factory = new NeoStateFactory<Definition.State>(){

        @Override
        public Definition.State beanFrom(Node node) {
            return new NeoDefinition(node);
        }

        @Override
        public Node nodeFrom(Definition.State state) {
            return new NeoDefinition(state).node();
        }
    };

    public NeoDefinition(Node node) {
        super(node);
    }

    public NeoDefinition(Definition.State state) {
        super(Constants.NodeType.DEFINITION, (Identified.State)state);
        this.name(state.name());
        this.type(state.type());
        this.language(state.language());
        this.valueType(state.valueType());
        this.range(state.range());
        this.shared(state.isShared());
    }

    public boolean isShared() {
        return (Boolean)this.node().getProperty("shared", (Object)true);
    }

    void shared(boolean flag) {
        if (!flag) {
            this.node().setProperty("shared", (Object)flag);
        }
    }

    public QName name() {
        return QName.valueOf((String)this.node().getProperty("name"));
    }

    public void name(QName name) {
        this.node().setProperty("name", (Object)name.toString());
    }

    public QName type() {
        String val = (String)this.node().getProperty("type", null);
        return val == null ? null : QName.valueOf(val);
    }

    public void type(QName type) {
        if (type == null) {
            this.node().removeProperty("type");
        } else {
            this.node().setProperty("type", (Object)type.toString());
        }
    }

    public String language() {
        return (String)this.node().getProperty("lang", null);
    }

    public void language(String language) {
        if (language == null) {
            this.node().removeProperty("lang");
        } else {
            this.node().setProperty("lang", (Object)language);
        }
    }

    public ValueType valueType() {
        return (ValueType)NeoUtils.binder().fromXML((String)this.node().getProperty("attr_type"));
    }

    public void valueType(ValueType state) {
        this.node().setProperty("attr_type", (Object)NeoUtils.binder().toXML((Object)state));
    }

    public Range range() {
        return (Range)NeoUtils.binder().fromXML((String)this.node().getProperty("range"));
    }

    public void range(Range type) {
        this.node().setProperty("range", (Object)NeoUtils.binder().toXML((Object)type));
    }

    public Definition.Private entity() {
        return new Definition.Private((Definition.State)this);
    }
}

