/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.lifecycle.impl;

import com.googlecode.stateless4j.StateMachine;
import java.util.Arrays;
import org.cotrix.action.Action;
import org.cotrix.action.CodelistAction;
import org.cotrix.common.CommonUtils;
import org.cotrix.lifecycle.Lifecycle;
import org.cotrix.lifecycle.LifecycleFactory;
import org.cotrix.lifecycle.State;
import org.cotrix.lifecycle.impl.DefaultLifecycleStates;
import org.cotrix.lifecycle.impl.S4JLifecycle;

public class S4JLifecycleFactory
implements LifecycleFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public String name() {
        return "__default__";
    }

    @Override
    public Lifecycle create(String id) {
        return this.create(id, DefaultLifecycleStates.draft);
    }

    @Override
    public Lifecycle create(String id, State startState) {
        CommonUtils.valid((String)"resource identifier", (String)id);
        CommonUtils.notNull((String)"state", (Object)startState);
        StateMachine<State, Action> machine = null;
        if (!Arrays.asList(DefaultLifecycleStates.values()).contains(startState)) {
            throw new IllegalArgumentException("invalid state " + startState + " for this lifecycle");
        }
        try {
            machine = this.machine(id, startState);
        }
        catch (Exception e) {
            throw new RuntimeException("error creating lifecycle", e);
        }
        return new S4JLifecycle(this.name(), id, machine);
    }

    private StateMachine<State, Action> machine(String id, State state) throws Exception {
        StateMachine machine = new StateMachine((Object)state);
        machine.Configure((Object)DefaultLifecycleStates.draft).PermitReentry((Object)CodelistAction.VIEW.on(id)).PermitReentry((Object)CodelistAction.EDIT.on(id)).Permit((Object)CodelistAction.LOCK.on(id), (Object)DefaultLifecycleStates.locked).Permit((Object)CodelistAction.REMOVE.on(id), (Object)DefaultLifecycleStates.removed).PermitReentry((Object)CodelistAction.VERSION.on(id)).PermitReentry((Object)CodelistAction.PUBLISH.on(id)).PermitReentry((Object)CodelistAction.REMOVE_LOGBOOK_ENTRY.on(id));
        machine.Configure((Object)DefaultLifecycleStates.locked).PermitReentry((Object)CodelistAction.VIEW.on(id)).Permit((Object)CodelistAction.SEAL.on(id), (Object)DefaultLifecycleStates.sealed).Permit((Object)CodelistAction.UNLOCK.on(id), (Object)DefaultLifecycleStates.draft).Permit((Object)CodelistAction.REMOVE.on(id), (Object)DefaultLifecycleStates.removed).PermitReentry((Object)CodelistAction.VERSION.on(id)).PermitReentry((Object)CodelistAction.PUBLISH.on(id));
        machine.Configure((Object)DefaultLifecycleStates.sealed).Permit((Object)CodelistAction.UNSEAL.on(id), (Object)DefaultLifecycleStates.locked).PermitReentry((Object)CodelistAction.VIEW.on(id)).PermitReentry((Object)CodelistAction.VERSION.on(id)).PermitReentry((Object)CodelistAction.PUBLISH.on(id));
        return machine;
    }
}

