/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.lifecycle.impl;

import javax.enterprise.event.Event;
import org.cotrix.common.Utils;
import org.cotrix.lifecycle.Lifecycle;
import org.cotrix.lifecycle.LifecycleEvent;
import org.cotrix.lifecycle.utils.NullEvent;

public abstract class AbstractLifecycle
implements Lifecycle {
    private static final long serialVersionUID = 1L;
    protected final String name;
    final String id;
    private Event<LifecycleEvent> event = new NullEvent();

    public AbstractLifecycle(String name, String id) {
        Utils.valid((String)"lifecycle name", (String)name);
        Utils.valid((String)"resource identifier", (String)id);
        this.name = name;
        this.id = id;
    }

    @Override
    public void setEventProducer(Event<LifecycleEvent> producer) {
        Utils.notNull((String)"producer", producer);
        this.event = producer;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String resourceId() {
        return this.id;
    }

    protected Event<LifecycleEvent> eventProducer() {
        return this.event;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractLifecycle other = (AbstractLifecycle)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

