/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.tabular.map;

import org.cotrix.common.Report;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.io.tabular.map.ColumnDirectives;
import org.virtualrepository.tabular.Row;

public class Column2Attribute {
    private final ColumnDirectives mapping;

    public Column2Attribute(ColumnDirectives mapping) {
        this.mapping = mapping;
    }

    public Attribute map(String codename, Row row) {
        String value = row.get(this.mapping.column());
        if (!this.valid(codename, value)) {
            return null;
        }
        Attribute attribute = null;
        AttributeGrammar.TypeClause sentence = ((AttributeGrammar.ValueClause)Codes.attribute().name(this.mapping.name())).value(value);
        attribute = this.mapping.type() != null ? (this.mapping.language() != null ? (Attribute)sentence.ofType(this.mapping.type()).in(this.mapping.language()).build() : (Attribute)sentence.ofType(this.mapping.type()).build()) : (this.mapping.language() != null ? (Attribute)sentence.in(this.mapping.language()).build() : (Attribute)sentence.build());
        return attribute;
    }

    private boolean valid(String codename, String value) {
        if (value == null || value.isEmpty()) {
            String msg = "code " + codename + " has no value for attribute '" + this.mapping.name() + "'";
            switch (this.mapping.mode()) {
                case STRICT: {
                    Report.report().logError(msg);
                    break;
                }
                case LOG: {
                    Report.report().logWarning(msg);
                }
            }
            return false;
        }
        return true;
    }
}

