/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.tabular.map;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.cotrix.common.Report;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Attribute;
import org.cotrix.io.impl.MapTask;
import org.cotrix.io.tabular.map.AttributeDirectives;
import org.cotrix.io.tabular.map.Codelist2TableDirectives;
import org.virtualrepository.tabular.Column;
import org.virtualrepository.tabular.DefaultTable;
import org.virtualrepository.tabular.Row;
import org.virtualrepository.tabular.Table;

public class Codelist2Table
implements MapTask<Codelist, Table, Codelist2TableDirectives> {
    public static final String DEFAULT_CODE_COLUMN_NAME = "code";

    @Override
    public Class<Codelist2TableDirectives> directedBy() {
        return Codelist2TableDirectives.class;
    }

    @Override
    public Table map(Codelist list, Codelist2TableDirectives directives) throws Exception {
        double time = System.currentTimeMillis();
        Report.report().log("mapping codelist " + list.name() + "(" + list.id() + ") to table");
        Report.report().log(Calendar.getInstance().getTime().toString());
        ArrayList<Column> columns = new ArrayList<Column>();
        QName codeColumnName = directives.codeColumnName() == null ? new QName(DEFAULT_CODE_COLUMN_NAME) : directives.codeColumnName();
        columns.add(new Column(codeColumnName));
        HashMap<QName, AttributeDirectives> directiveMap = new HashMap<QName, AttributeDirectives>();
        for (AttributeDirectives directive : directives.attributes()) {
            directiveMap.put(directive.template().name(), directive);
            columns.add(new Column(directive.columnName()));
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Code code : list.codes()) {
            HashMap<QName, String> values = new HashMap<QName, String>();
            HashMap<QName, Attribute> matches = new HashMap<QName, Attribute>();
            values.put(codeColumnName, code.name().getLocalPart());
            for (Attribute a : code.attributes()) {
                if (!directiveMap.containsKey(a.name()) || !this.matches(((AttributeDirectives)directiveMap.get(a.name())).template(), a)) continue;
                matches.put(((AttributeDirectives)directiveMap.get(a.name())).columnName(), a);
            }
            for (Column col : columns) {
                String error = "mapping is ambiguous: code " + code.name() + " has multiple attributes that map onto column " + col.name();
                if (!matches.containsKey(col.name())) continue;
                if (values.containsKey(col.name())) {
                    switch (directives.mode()) {
                        case STRICT: {
                            throw new IllegalStateException(error);
                        }
                        case LOG: {
                            Report.report().logWarning(error);
                        }
                    }
                }
                values.put(col.name(), ((Attribute)matches.get(col.name())).value());
            }
            rows.add(new Row(values));
        }
        Report.report().log("mapped codelist " + list.name() + "(" + list.id() + ") to table in " + ((double)System.currentTimeMillis() - time) / 1000.0);
        return new DefaultTable(columns, rows);
    }

    private boolean matches(Attribute template, Attribute attribute) {
        if (!template.name().equals(attribute.name())) {
            return false;
        }
        if (template.type() != null && !template.type().equals(attribute.type())) {
            return false;
        }
        return template.language() == null || template.language().equals(attribute.language());
    }
}

