/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.tabular.csv.serialise;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.cotrix.io.impl.SerialisationTask;
import org.cotrix.io.tabular.csv.serialise.Table2CsvDirectives;
import org.virtualrepository.csv.CsvCodelist;
import org.virtualrepository.tabular.Column;
import org.virtualrepository.tabular.Row;
import org.virtualrepository.tabular.Table;

public class Table2Csv
implements SerialisationTask<Table, Table2CsvDirectives> {
    @Override
    public Class<Table2CsvDirectives> directedBy() {
        return Table2CsvDirectives.class;
    }

    @Override
    public void serialise(Table table, OutputStream stream, Table2CsvDirectives directives) throws Exception {
        CsvCodelist opts = directives.options();
        CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter(stream), opts.delimiter(), opts.quote());
        ArrayList<String> values = new ArrayList<String>();
        if (opts.hasHeader()) {
            for (Column column : table.columns()) {
                values.add(column.name().toString());
            }
            writer.writeNext(values.toArray(new String[0]));
        }
        for (Row row : table) {
            values.clear();
            for (Column column : table.columns()) {
                values.add(row.get(column));
            }
            writer.writeNext(values.toArray(new String[0]));
        }
        writer.flush();
        writer.close();
    }

    public String toString() {
        return "table-2-csv";
    }
}

