/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.dsl.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.builder.BuilderUtils;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.LinkGrammar;
import org.cotrix.domain.links.Link;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.memory.MLink;

public class LinkBuilder
implements LinkGrammar.ThirdClause,
LinkGrammar.SecondClause,
LinkGrammar.CodelinkChangeClause {
    private final MLink state;

    public LinkBuilder(MLink state) {
        this.state = state;
    }

    @Override
    public LinkGrammar.ThirdClause target(Code code) {
        CommonUtils.notNull((String)"code", (Object)code);
        Code.Private privatecode = Data.reveal(code);
        if (privatecode.isChangeset()) {
            throw new IllegalArgumentException("invalid link: target code cannot be a changeset");
        }
        Code.Bean target = (Code.Bean)privatecode.bean();
        this.state.target(target);
        return this;
    }

    @Override
    public LinkGrammar.ThirdClause attributes(Attribute ... attributes) {
        return this.attributes(Arrays.asList(attributes));
    }

    @Override
    public LinkGrammar.ThirdClause attributes(Collection<Attribute> attributes) {
        this.state.attributes(BuilderUtils.reveal(attributes, Attribute.Private.class));
        return this;
    }

    @Override
    public LinkGrammar.ThirdClause attributes(AttributeGrammar.FourthClause ... clauses) {
        ArrayList as = new ArrayList();
        for (AttributeGrammar.FourthClause clause : clauses) {
            as.add(clause.build());
        }
        return this.attributes((Collection)as);
    }

    @Override
    public Link build() {
        return this.state.entity();
    }

    public class NewClause
    implements LinkGrammar.CodelinkNewClause {
        @Override
        public LinkGrammar.SecondClause instanceOf(LinkDefinition linktype) {
            LinkDefinition.Private type = Data.reveal(linktype);
            if (type.isChangeset()) {
                throw new IllegalArgumentException("invalid link: link type cannot be a changeset");
            }
            LinkBuilder.this.state.definition((LinkDefinition.Bean)type.bean());
            return LinkBuilder.this;
        }
    }
}

