/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.common;

import org.cotrix.common.CommonUtils;

public interface Range {
    public int min();

    public int max();

    public boolean inRange(int var1);

    public static class Default
    implements Range {
        private final int min;
        private final int max;

        public Default(int min) {
            this(min, Integer.MAX_VALUE);
        }

        public Default(int min, int max) {
            CommonUtils.verify((String)"invalid range bounds", (min >= 0 && max > 0 && min <= max ? 1 : 0) != 0);
            this.min = min;
            this.max = max;
        }

        @Override
        public int min() {
            return this.min;
        }

        @Override
        public int max() {
            return this.max;
        }

        @Override
        public boolean inRange(int occurrence) {
            return occurrence >= this.min && occurrence <= this.max;
        }

        public String toString() {
            return "[min=" + this.min + ", max=" + this.max + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.max;
            result = 31 * result + this.min;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Default other = (Default)obj;
            if (this.max != other.max) {
                return false;
            }
            return this.min == other.min;
        }
    }
}

