/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.dsl.builder;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.cotrix.common.Utils;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.builder.BuilderUtils;
import org.cotrix.domain.dsl.grammar.CodelistLinkGrammar;
import org.cotrix.domain.dsl.grammar.CommonClauses;
import org.cotrix.domain.links.AttributeLink;
import org.cotrix.domain.links.LinkOfLink;
import org.cotrix.domain.links.NameLink;
import org.cotrix.domain.links.OccurrenceRange;
import org.cotrix.domain.links.ValueFunction;
import org.cotrix.domain.memory.CodelistLinkMS;
import org.cotrix.domain.utils.AttributeTemplate;

public class CodelistLinkBuilder {
    private final CodelistLinkMS state;

    public CodelistLinkBuilder(CodelistLinkMS state) {
        this.state = state;
    }

    public void name(QName name) {
        this.state.name(name);
    }

    public void name(String name) {
        this.name(Codes.q(name));
    }

    public class OptClause
    implements CodelistLinkGrammar.OptionalClause {
        @Override
        public CodelistLinkGrammar.OptionalClause anchorTo(Attribute template) {
            CodelistLinkBuilder.this.state.valueType(new AttributeLink(new AttributeTemplate(template)));
            return this;
        }

        @Override
        public CodelistLinkGrammar.OptionalClause anchorTo(CodelistLink template) {
            CodelistLinkBuilder.this.state.valueType(new LinkOfLink(template));
            return this;
        }

        @Override
        public CodelistLinkGrammar.OptionalClause anchorToName() {
            CodelistLinkBuilder.this.state.valueType(NameLink.INSTANCE);
            return this;
        }

        @Override
        public CodelistLinkGrammar.OptionalClause attributes(Attribute ... attributes) {
            this.attributes((List)Arrays.asList(attributes));
            return this;
        }

        @Override
        public CodelistLinkGrammar.OptionalClause attributes(List<Attribute> attributes) {
            CodelistLinkBuilder.this.state.attributes(BuilderUtils.reveal(attributes, Attribute.Private.class));
            return this;
        }

        @Override
        public CodelistLinkGrammar.OptionalClause transformWith(ValueFunction function) {
            CodelistLinkBuilder.this.state.function(function);
            return this;
        }

        @Override
        public CodelistLinkGrammar.OptionalClause occurs(OccurrenceRange range) {
            CodelistLinkBuilder.this.state.range(range);
            return this;
        }

        @Override
        public CodelistLink build() {
            return CodelistLinkBuilder.this.state.entity();
        }
    }

    public class ChangeClause
    extends OptClause
    implements CodelistLinkGrammar.CodelistLinkChangeClause {
        @Override
        public CodelistLinkGrammar.OptionalClause name(QName name) {
            CodelistLinkBuilder.this.name(name);
            return this;
        }

        @Override
        public CodelistLinkGrammar.OptionalClause name(String name) {
            CodelistLinkBuilder.this.name(name);
            return this;
        }
    }

    public class NewClause
    implements CodelistLinkGrammar.CodelistLinkNewClause,
    CommonClauses.LinkTargetClause<Codelist, CodelistLinkGrammar.OptionalClause> {
        @Override
        public NewClause name(QName name) {
            CodelistLinkBuilder.this.name(name);
            return this;
        }

        @Override
        public NewClause name(String name) {
            CodelistLinkBuilder.this.name(name);
            return this;
        }

        @Override
        public CodelistLinkGrammar.OptionalClause target(Codelist target) {
            Utils.notNull((String)"codelist", (Object)target);
            Codelist.Private list = Codes.reveal(target);
            if (list.isChangeset()) {
                throw new IllegalArgumentException("invalid link: target codelist cannot be a changeset");
            }
            CodelistLinkBuilder.this.state.target((Codelist.State)list.state());
            return new OptClause();
        }
    }
}

