/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.codelist;

import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.links.OccurrenceRange;
import org.cotrix.domain.links.ValueFunction;
import org.cotrix.domain.links.ValueType;
import org.cotrix.domain.trait.Attributed;
import org.cotrix.domain.trait.EntityProvider;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;

public interface CodelistLink
extends Identified,
Attributed,
Named {
    public Codelist target();

    public ValueType valueType();

    public ValueFunction function();

    public OccurrenceRange range();

    public static class Private
    extends Named.Abstract<Private, State>
    implements CodelistLink {
        public Private(State state) {
            super(state);
        }

        @Override
        public Codelist target() {
            return ((State)this.state()).target() == null ? null : new Codelist.Private(((State)this.state()).target());
        }

        @Override
        public ValueType valueType() {
            return ((State)this.state()).valueType();
        }

        @Override
        public ValueFunction function() {
            return ((State)this.state()).function();
        }

        @Override
        public OccurrenceRange range() {
            return ((State)this.state()).range();
        }

        @Override
        public void update(Private changeset) throws IllegalArgumentException, IllegalStateException {
            OccurrenceRange newrange;
            ValueFunction newfunction;
            super.update(changeset);
            ValueType newtype = ((State)changeset.state()).valueType();
            if (newtype != null) {
                ((State)this.state()).valueType(newtype);
            }
            if ((newfunction = ((State)changeset.state()).function()) != null) {
                ((State)this.state()).function(newfunction);
            }
            if ((newrange = ((State)changeset.state()).range()) != null) {
                ((State)this.state()).range(newrange);
            }
        }
    }

    public static interface State
    extends Identified.State,
    Attributed.State,
    Named.State,
    EntityProvider<Private> {
        public Codelist.State target();

        public ValueType valueType();

        public void valueType(ValueType var1);

        public ValueFunction function();

        public void function(ValueFunction var1);

        public void target(Codelist.State var1);

        public OccurrenceRange range();

        public void range(OccurrenceRange var1);
    }
}

