/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.common.async;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.cotrix.common.async.TaskObserver;

public class Task {
    private Map<Class<?>, Object> data = new HashMap();
    private Map<Class<?>, TaskObserver<Object>> observers = new HashMap();
    private Exception failure;

    public <T> void add(Class<T> type, TaskObserver<T> observer) {
        this.observers.put(type, observer);
    }

    void failed(Exception e) {
        this.failure = e;
        for (TaskObserver<Object> observer : this.observers.values()) {
            try {
                observer.on(this.failure);
            }
            catch (Throwable throwable) {}
        }
    }

    void put(Object o) {
        Class<?> type = o.getClass();
        this.data.put(type, o);
        TaskObserver<Object> observer = this.observers.get(type);
        if (observer != null) {
            observer.on(o);
        }
    }

    <T> T get(Class<T> type) throws ExecutionException {
        if (this.failure == null) {
            return type.cast(this.data.get(type));
        }
        throw new ExecutionException(this.failure);
    }
}

