/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.common.async;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cotrix.common.async.ReportingFuture;
import org.cotrix.common.async.Task;
import org.cotrix.common.async.TaskObserver;
import org.cotrix.common.async.TaskUpdate;

public class DefaultReportingFuture<T>
implements ReportingFuture<T> {
    private final Future<T> inner;
    private final Task context;
    private final Object cancelMonitor;

    public DefaultReportingFuture(Future<T> future, Task context, Object cancelMonitor) {
        this.inner = future;
        this.context = context;
        this.cancelMonitor = cancelMonitor;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.inner.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.cancelMonitor;
        synchronized (object) {
            try {
                TaskUpdate update = this.get(TaskUpdate.class);
                return update == null || update.progress() < 1.0f ? this.inner.cancel(mayInterruptIfRunning) : false;
            }
            catch (ExecutionException e) {
                return false;
            }
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.inner.get(timeout, unit);
    }

    @Override
    public boolean isDone() {
        return this.inner.isDone();
    }

    @Override
    public boolean isCancelled() {
        return this.inner.isCancelled();
    }

    @Override
    public <S> ReportingFuture.ForClause<T, S> register(final TaskObserver<S> observer) {
        return new ReportingFuture.ForClause<T, S>(){

            @Override
            public ReportingFuture<T> forType(Class<S> type) {
                DefaultReportingFuture.this.context.add(type, observer);
                return DefaultReportingFuture.this;
            }
        };
    }

    @Override
    public <S> S get(Class<S> type) throws ExecutionException {
        return this.context.get(type);
    }
}

