/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.common.async;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.cotrix.common.CommonUtils;
import org.cotrix.common.async.CancelledTaskException;
import org.cotrix.common.async.DefaultReportingFuture;
import org.cotrix.common.async.ExecutionService;
import org.cotrix.common.async.ReportingFuture;
import org.cotrix.common.async.Task;
import org.cotrix.common.async.TaskContext;
import org.cotrix.common.async.TaskManagerProvider;
import org.cotrix.common.async.TaskUpdate;
import org.cotrix.common.tx.Transaction;
import org.cotrix.common.tx.Transactions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultExecutionService
implements ExecutionService {
    private static ExecutorService service = Executors.newCachedThreadPool();
    private Logger logger = LoggerFactory.getLogger(DefaultExecutionService.class);
    @Inject
    private TaskContext context;
    @Inject
    private TaskManagerProvider managers;
    @Inject
    Transactions txs;

    @Override
    public <T> ReportingFuture<T> execute(final Callable<T> task) throws RejectedExecutionException {
        CommonUtils.notNull("task", task);
        try {
            final CountDownLatch started = new CountDownLatch(1);
            final Closure closure = new Closure();
            final TaskManagerProvider.TaskManager manager = this.managers.get();
            final Object cancelMonitor = new Object();
            Callable wrap = new Callable<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T call() throws Exception {
                    manager.started();
                    try {
                        Object object;
                        Object object2;
                        closure.t = DefaultExecutionService.this.context.thisTask();
                        started.countDown();
                        Transaction tx = DefaultExecutionService.this.txs.open();
                        try {
                            DefaultExecutionService.this.logger.trace("started transaction for async task {}", (Object)tx);
                            Object result = task.call();
                            object2 = cancelMonitor;
                            synchronized (object2) {
                                if (!Thread.currentThread().isInterrupted()) {
                                    tx.commit();
                                    DefaultExecutionService.this.context.save(TaskUpdate.update(1.0f, "task completing"));
                                    DefaultExecutionService.this.logger.trace("committed transaction {}", (Object)tx);
                                }
                            }
                            object2 = result;
                            object = cancelMonitor;
                        }
                        catch (Throwable throwable) {
                            try {
                                Object object3 = cancelMonitor;
                                synchronized (object3) {
                                    Thread.interrupted();
                                    tx.close();
                                }
                                throw throwable;
                            }
                            catch (CancelledTaskException e) {
                                throw new InterruptedException(e.getMessage());
                            }
                            catch (Exception e) {
                                DefaultExecutionService.this.context.thisTask().failed(e);
                                throw e;
                            }
                        }
                        synchronized (object) {
                            Thread.interrupted();
                            tx.close();
                        }
                        return object2;
                    }
                    finally {
                        DefaultExecutionService.this.context.reset();
                        manager.finished();
                    }
                }
            };
            Future future = service.submit(wrap);
            started.await();
            return new DefaultReportingFuture(future, closure.t, cancelMonitor);
        }
        catch (Exception e) {
            throw CommonUtils.unchecked(e);
        }
    }

    private static class Closure {
        Task t;

        private Closure() {
        }
    }
}

