/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.changelog;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.cotrix.application.changelog.Changelog;
import org.cotrix.application.changelog.ChangelogEntry;
import org.cotrix.application.shared.EditorialEvent;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.Facet;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.common.Containers;
import org.cotrix.domain.links.Link;
import org.cotrix.domain.links.LinkDefinition;

public class ChangelogProducer {
    private final Changelog log = new Changelog();

    public Changelog changesBetween(Code origin, Code current) {
        this.addCodeChanges(origin, current);
        this.addAttributesChanges(origin, current);
        this.addLinkChanges(origin, current);
        return this.log;
    }

    private void addCodeChanges(Code origin, Code current) {
        this.add(ChangelogEntry.entry(current), "name change", origin.qname(), current.qname());
    }

    private void addAttributesChanges(Code origin, Code current) {
        Containers.Attributes attributesBefore = origin.attributes();
        ArrayList<String> matched = new ArrayList<String>();
        for (Attribute attr : current.attributes()) {
            if (!attr.is(Facet.LOGGABLE)) continue;
            String id = attr.id();
            if (attributesBefore.contains(id)) {
                this.addAttributeChanges(current, (Attribute)attributesBefore.lookup(id), attr);
                matched.add(id);
                continue;
            }
            ChangelogEntry e = ChangelogEntry.entry(EditorialEvent.Type.ADDITION, current, attr).to(attr.qname());
            e.description("added attribute");
            this.log.add(e);
        }
        for (Attribute attr : origin.attributes()) {
            if (!attr.is(Facet.LOGGABLE) || matched.contains(attr.id())) continue;
            ChangelogEntry e = ChangelogEntry.entry(EditorialEvent.Type.DELETION, current, attr).from(attr.qname().getLocalPart());
            e.description("removed attribute");
            this.log.add(e);
        }
    }

    private void addLinkChanges(Code origin, Code current) {
        Containers.Links linksBefore = origin.links();
        ArrayList<String> matched = new ArrayList<String>();
        for (Link link : current.links()) {
            String id = link.id();
            if (linksBefore.contains(id)) {
                this.addLinkChanges(current, (Link)linksBefore.lookup(id), link);
                matched.add(id);
                continue;
            }
            ChangelogEntry e = ChangelogEntry.entry(EditorialEvent.Type.ADDITION, current, link).to(link.qname());
            e.description("added link");
            this.log.add(e);
        }
        for (Link link : origin.links()) {
            if (matched.contains(link.id())) continue;
            ChangelogEntry e = ChangelogEntry.entry(EditorialEvent.Type.DELETION, current, link).from(link.qname());
            e.description("removed link");
            this.log.add(e);
        }
    }

    private void addAttributeChanges(Code code, Attribute origin, Attribute current) {
        this.add(ChangelogEntry.entry(code, current), "name change", origin.qname(), current.qname());
        this.add(ChangelogEntry.entry(code, current), "value change", origin.value(), current.value());
        this.add(ChangelogEntry.entry(code, current), "type change", origin.type(), current.type());
        this.add(ChangelogEntry.entry(code, current), "language change", origin.language(), current.language());
    }

    private void addLinkChanges(Code code, Link origin, Link current) {
        LinkDefinition origindef = (LinkDefinition)origin.definition();
        LinkDefinition currentdef = (LinkDefinition)current.definition();
        this.add(ChangelogEntry.entry(code, current), "name change", origindef.qname(), origindef.qname());
        String tformat = "%s $s";
        String torigin = String.format(tformat, this.local(origindef.target().qname()), origindef.target().version());
        String tcurrent = String.format(tformat, this.local(currentdef.target().qname()), currentdef.target().version());
        this.add(ChangelogEntry.entry(code, current), "target list change", torigin, tcurrent);
        this.add(ChangelogEntry.entry(code, current), "target code change", origin.target().qname(), current.target().qname());
        this.add(ChangelogEntry.entry(code, current), "value change", origin.valueAsString(), current.valueAsString());
    }

    private void add(ChangelogEntry entry, String type, Object origin, Object current) {
        origin = origin == null ? "[none]" : origin;
        Object object = current = current == null ? "[none]" : current;
        if (!origin.equals(current)) {
            if (origin instanceof QName) {
                origin = ((QName)QName.class.cast(origin)).getLocalPart();
            }
            if (current instanceof QName) {
                current = ((QName)QName.class.cast(current)).getLocalPart();
            }
            String description = String.format("%s: %s \u2192 %s", type, origin, current);
            entry.from(origin).to(current).description(description);
            this.log.add(entry);
        }
    }

    String local(QName name) {
        return name.getLocalPart();
    }
}

