/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.changelog;

import org.cotrix.application.shared.DefaultEditorialEvent;
import org.cotrix.application.shared.EditorialEvent;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.links.Link;
import org.cotrix.domain.links.LinkDefinition;

public class ChangelogEntry
extends DefaultEditorialEvent {
    private static final String compound = "%s:%s";
    private final String id;
    private final String name;
    private String from;
    private String to;

    public static ChangelogEntry entry(Code c) {
        String id = c.id();
        String name = c.qname().toString();
        return new ChangelogEntry(EditorialEvent.Type.CHANGE, c.qname().getLocalPart(), id, name);
    }

    public static ChangelogEntry entry(Code c, Link l) {
        return ChangelogEntry.entry(EditorialEvent.Type.CHANGE, c, l);
    }

    public static ChangelogEntry entry(EditorialEvent.Type type, Code c, Link l) {
        String id = String.format(compound, c.id(), ((LinkDefinition)l.definition()).id());
        String name = String.format(compound, c.qname(), l.qname());
        ChangelogEntry e = new ChangelogEntry(type, l.qname().getLocalPart(), id, name);
        return e;
    }

    public static ChangelogEntry entry(Code c, Attribute a) {
        return ChangelogEntry.entry(EditorialEvent.Type.CHANGE, c, a);
    }

    public static ChangelogEntry entry(EditorialEvent.Type type, Code c, Attribute a) {
        String id = String.format(compound, c.id(), ((AttributeDefinition)a.definition()).id());
        String name = String.format(compound, c.qname(), a.qname());
        ChangelogEntry e = new ChangelogEntry(type, a.qname().getLocalPart(), id, name);
        e.subtitle(a.language() == null ? a.type().getLocalPart() : a.type().getLocalPart() + "," + a.language());
        return e;
    }

    public ChangelogEntry(EditorialEvent.Type type, String title, String id, String name) {
        super(type, title);
        this.id = id;
        this.name = name;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String from() {
        return this.from;
    }

    public String to() {
        return this.to;
    }

    ChangelogEntry from(Object val) {
        this.from = val.toString();
        return this;
    }

    ChangelogEntry to(Object val) {
        this.to = val.toString();
        return this;
    }
}

