/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.shared;

import org.cotrix.application.shared.EditorialEvent;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.utils.DomainUtils;

public class DefaultEditorialEvent
implements EditorialEvent,
Comparable<EditorialEvent> {
    private String title;
    private String subtitle;
    private String description;
    private String user;
    private String timestamp;
    private final EditorialEvent.Type type;

    public DefaultEditorialEvent(EditorialEvent.Type type, Object title) {
        this.title = title.toString();
        this.type = type;
        this.user = DomainUtils.currentUser().name();
        this.timestamp = CommonUtils.time();
    }

    protected void subtitle(String title) {
        this.subtitle = title;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String subtitle() {
        return this.subtitle;
    }

    @Override
    public String description() {
        return this.description;
    }

    public void description(String description) {
        this.description = description;
    }

    @Override
    public EditorialEvent.Type type() {
        return this.type;
    }

    @Override
    public String timestamp() {
        return this.timestamp;
    }

    @Override
    public String user() {
        return this.user;
    }

    @Override
    public int compareTo(EditorialEvent o) {
        return CommonUtils.time((String)o.timestamp()).compareTo(CommonUtils.time((String)this.timestamp));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultEditorialEvent other = (DefaultEditorialEvent)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }
}

