/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.impl.delegation;

import org.cotrix.action.Action;
import org.cotrix.application.DelegationPolicy;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;

public class DefaultDelegationPolicy
implements DelegationPolicy {
    @Override
    public void validateDelegation(User source, User target, Action ... actions) {
        for (Action action : actions) {
            if (action.isTemplate() && !source.isRoot()) {
                throw new IllegalAccessError(source.name() + " cannot delegate or revoke template " + action + ", as she does not have root privileges");
            }
            if (source.can(action)) continue;
            throw new IllegalAccessError(source.name() + " cannot perform " + action + ", hence cannot delegate it or revoke it to or from " + target.name());
        }
    }

    @Override
    public void validateRevocation(User source, User target, Action ... actions) {
        this.validateDelegation(source, target, actions);
    }

    @Override
    public void validateDelegation(User source, User target, Role ... roles) {
        for (Role role : roles) {
            if (!source.is(role)) {
                throw new IllegalAccessError(source.name() + " does not have role " + role + ", hence cannot delegate or revoke it to or from " + target.name());
            }
            for (Action action : role.permissions()) {
                if (!action.isTemplate() || action.type() != role.type() || source.isRoot()) continue;
                throw new IllegalAccessError(source.name() + " cannot delegate or revoke template " + action + ", as she does not have root privileges");
            }
        }
    }

    @Override
    public void validateRevocation(User source, User target, Role ... roles) {
        this.validateDelegation(source, target, roles);
    }
}

