/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import org.cotrix.action.Action;
import org.cotrix.action.Actions;
import org.cotrix.action.ResourceType;
import org.cotrix.application.DelegationPolicy;
import org.cotrix.application.impl.delegation.DefaultDelegationPolicy;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.dsl.grammar.UserGrammar;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.junit.Test;

public class DefaultDelegationPolicyTest {
    static Action doit = Actions.action((String)"doit", (String[])new String[0]);
    DelegationPolicy policy = new DefaultDelegationPolicy();

    @Test(expected=IllegalAccessError.class)
    public void delegatesOnlyOwnPermissions() {
        User joe = Users.user().name("joe").fullName("joe").email("joe@me.com").build();
        User bill = Users.user().name("bill").fullName("bill").email("bil@me.coml").build();
        this.policy.validateDelegation(joe, bill, new Action[]{doit});
    }

    @Test(expected=IllegalAccessError.class)
    public void doesNotDelegateTemplatesForNonRootUsers() {
        User joe = this.someuser("joe").can(new Action[]{doit}).build();
        User bill = this.someuser("bill").build();
        this.policy.validateDelegation(joe, bill, new Action[]{doit});
    }

    @Test
    public void delegatesTemplatesForRootUsers() {
        User joe = this.someuser("joe").isRoot().can(new Action[]{doit}).build();
        User bill = this.someuser("bill").build();
        this.policy.validateDelegation(joe, bill, new Action[]{doit});
    }

    @Test
    public void delegatesRolesWithTemplatesOfDifferentTypesForNonRootUsers() {
        Action doGeneric = Actions.action((ResourceType)ResourceType.application, (String)"generic", (String[])new String[0]);
        Role something = this.someuser("r1").can(new Action[]{doGeneric}).buildAsRoleFor(ResourceType.application);
        Action doSpecific = Actions.action((ResourceType)ResourceType.codelists, (String)"specific", (String[])new String[0]);
        Role somethingElse = this.someuser("r2").is(new Role[]{something}).can(new Action[]{doSpecific}).buildAsRoleFor(ResourceType.codelists);
        User joe = this.someuser("joe").is(new Role[]{somethingElse.on("1")}).build();
        User bill = this.someuser("bill").build();
        this.policy.validateDelegation(joe, bill, new Role[]{somethingElse.on("1")});
    }

    UserGrammar.ThirdClause someuser(String n) {
        return Users.user().name(n).fullName(n).noMail();
    }
}

