/*
 * Decompiled with CFR 0.152.
 */
package smallgears.virtualrepository.spi;

import lombok.NonNull;
import smallgears.virtualrepository.Asset;
import smallgears.virtualrepository.AssetType;
import smallgears.virtualrepository.spi.Transform;
import smallgears.virtualrepository.spi.VirtualWriter;

public class WriterAdapter<A1, A2>
implements VirtualWriter<A2> {
    @NonNull
    private final VirtualWriter<A1> writer;
    @NonNull
    private final Transform<A2, A1> transform;

    @Override
    public AssetType type() {
        return this.writer.type();
    }

    @Override
    public Class<A2> api() {
        return this.transform.sourceApi();
    }

    @Override
    public void publish(Asset asset, A2 content) throws Exception {
        this.writer.publish(asset, this.transform.apply(asset, content));
    }

    private WriterAdapter(@NonNull VirtualWriter<A1> writer, @NonNull Transform<A2, A1> transform) {
        if (writer == null) {
            throw new IllegalArgumentException("writer is null");
        }
        if (transform == null) {
            throw new IllegalArgumentException("transform is null");
        }
        this.writer = writer;
        this.transform = transform;
    }

    public static <A1, A2> WriterAdapter<A1, A2> adapt(@NonNull VirtualWriter<A1> writer, @NonNull Transform<A2, A1> transform) {
        return new WriterAdapter<A1, A2>(writer, transform);
    }
}

