/*
 * Decompiled with CFR 0.152.
 */
package smallgears.virtualrepository.spi;

import smallgears.virtualrepository.Asset;
import smallgears.virtualrepository.AssetType;

public interface Transform<IN, OUT> {
    public OUT apply(Asset var1, IN var2) throws Exception;

    public AssetType type();

    public Class<IN> sourceApi();

    public Class<OUT> targetApi();

    default public <S> Transform<S, OUT> after(final Transform<S, IN> previous) {
        return new Transform<S, OUT>(){

            @Override
            public Class<S> sourceApi() {
                return previous.sourceApi();
            }

            @Override
            public AssetType type() {
                return previous.type();
            }

            @Override
            public Class<OUT> targetApi() {
                return Transform.this.targetApi();
            }

            @Override
            public OUT apply(Asset asset, S input) throws Exception {
                return Transform.this.apply(asset, previous.apply(asset, input));
            }
        };
    }

    default public <S> Transform<IN, S> then(Transform<OUT, S> previous) {
        return previous.after(this);
    }
}

