/*
 * Decompiled with CFR 0.152.
 */
package smallgears.virtualrepository.impl;

import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smallgears.api.Apikit;
import smallgears.api.group.Group;
import smallgears.virtualrepository.impl.Transforms;
import smallgears.virtualrepository.spi.Transform;
import smallgears.virtualrepository.spi.VirtualExtension;

public class Extensions
extends Group<VirtualExtension, Extensions> {
    private static final Logger log = LoggerFactory.getLogger(Extensions.class);
    Transforms transforms = new Transforms(new Transform[0]);

    public Extensions(VirtualExtension ... extensions) {
        super(VirtualExtension::name);
        if (extensions == null) {
            throw new IllegalArgumentException("extensions is null");
        }
        this.add(extensions);
    }

    public Extensions load() {
        ServiceLoader<VirtualExtension> loaded = ServiceLoader.load(VirtualExtension.class);
        List extensions = Apikit.streamof(loaded).collect(Collectors.toList());
        for (VirtualExtension extension : extensions) {
            try {
                this.load(extension);
            }
            catch (Throwable e) {
                log.error(String.format("extension %s cannot be activated and will be discarded (see cause)", extension.getClass()), e);
            }
        }
        log.info(extensions.isEmpty() ? "no extension found on classpath!" : "loaded {} extension(s)", (Object)this.size());
        return this;
    }

    public void shutdown() {
        this.forEach(extension -> {
            this.remove(new VirtualExtension[]{extension});
            try {
                extension.shutdown();
            }
            catch (Throwable t) {
                log.warn("no clean shutdown for extension " + extension.name() + " (see cause)", t);
            }
        });
    }

    protected void add(VirtualExtension extension) {
        this.validate(extension);
        this.transforms.add(extension.transforms());
        super.add((Object)extension);
        log.info("added extension: {}", (Object)extension.name());
    }

    private void load(VirtualExtension extension) throws Exception {
        extension.init();
        this.add(extension);
    }

    private void validate(VirtualExtension extension) throws IllegalArgumentException {
        try {
            Objects.requireNonNull(extension.name(), "extension name");
            if (this.has(new String[]{extension.name()})) {
                log.warn("{} supersides extension registered previously with the same name");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid extension " + extension.name() + " (see cause)", e);
        }
    }

    public Transforms transforms() {
        return this.transforms;
    }
}

