/*
 * Decompiled with CFR 0.152.
 */
package smallgears.virtualrepository.common;

import lombok.NonNull;
import smallgears.virtualrepository.AssetType;

public final class Utils {
    public static boolean ordered(@NonNull AssetType t1, @NonNull AssetType t2) {
        if (t1 == null) {
            throw new IllegalArgumentException("t1 is null");
        }
        if (t2 == null) {
            throw new IllegalArgumentException("t2 is null");
        }
        return t1.name().equals(t2.name()) || t2.name() == AssetType.any.name() || t1.specialises().stream().anyMatch(supertype -> Utils.ordered(supertype, t2));
    }

    public static boolean ordered(@NonNull Class<?> t1, @NonNull Class<?> t2) {
        if (t1 == null) {
            throw new IllegalArgumentException("t1 is null");
        }
        if (t2 == null) {
            throw new IllegalArgumentException("t2 is null");
        }
        return t1.equals(t2) || t2.isAssignableFrom(t1);
    }

    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

