/*
 * Decompiled with CFR 0.152.
 */
package smallgears.virtualrepository;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import smallgears.api.properties.Properties;
import smallgears.api.properties.Property;
import smallgears.virtualrepository.AssetType;
import smallgears.virtualrepository.common.Utils;
import smallgears.virtualrepository.spi.Accessor;
import smallgears.virtualrepository.spi.VirtualProxy;

public class Repository {
    @NonNull
    private final String name;
    @NonNull
    private final VirtualProxy proxy;
    private final Properties properties = Properties.props((Property[])new Property[0]);

    public List<AssetType> ingested(Collection<AssetType> types) {
        return this.filter(this.proxy.writers(), types);
    }

    public List<AssetType> disseminated(Collection<AssetType> types) {
        return this.filter(this.proxy.readers(), types);
    }

    public List<AssetType> ingested(AssetType ... types) {
        return this.ingested(Arrays.asList(types));
    }

    public boolean ingests(AssetType ... types) {
        return this.ingests(Arrays.asList(types));
    }

    public boolean ingests(Collection<AssetType> types) {
        return !this.ingested(types).isEmpty();
    }

    public List<AssetType> disseminated(AssetType ... types) {
        return this.disseminated(Arrays.asList(types));
    }

    public boolean disseminates(Collection<AssetType> types) {
        return !this.disseminated(types).isEmpty();
    }

    public boolean disseminates(AssetType ... types) {
        return this.disseminates(Arrays.asList(types));
    }

    private List<AssetType> filter(Collection<? extends Accessor<?>> elements, Collection<AssetType> types) {
        List<AssetType> supported = elements.stream().map(Accessor::type).distinct().collect(Collectors.toList());
        if (types.isEmpty()) {
            return supported;
        }
        return types.stream().distinct().filter(requested -> supported.stream().anyMatch(t -> Utils.ordered(requested, t))).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"name", "proxy"})
    public Repository(@NonNull String name, @NonNull VirtualProxy proxy) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (proxy == null) {
            throw new IllegalArgumentException("proxy is null");
        }
        this.name = name;
        this.proxy = proxy;
    }

    public String toString() {
        return "Repository(name=" + this.name() + ", properties=" + this.properties() + ")";
    }

    @NonNull
    public String name() {
        return this.name;
    }

    @NonNull
    public VirtualProxy proxy() {
        return this.proxy;
    }

    public Properties properties() {
        return this.properties;
    }
}

