/*
 * Decompiled with CFR 0.152.
 */
package smallgears.virtualrepository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smallgears.api.Apikit;
import smallgears.api.group.Group;
import smallgears.virtualrepository.AssetType;
import smallgears.virtualrepository.Repository;
import smallgears.virtualrepository.spi.VirtualPlugin;

public class Repositories
extends Group<Repository, Repositories> {
    private static final Logger log = LoggerFactory.getLogger((String)"virtual-repository");
    private List<VirtualPlugin> plugins = new ArrayList<VirtualPlugin>();

    public Repositories(Repository ... repositories) {
        this(Arrays.asList(repositories));
        if (repositories == null) {
            throw new IllegalArgumentException("repositories is null");
        }
    }

    public Repositories(@NonNull Iterable<Repository> repositories) {
        super(Repository::name);
        if (repositories == null) {
            throw new IllegalArgumentException("repositories is null");
        }
        this.add(repositories);
    }

    protected void add(@NonNull Repository repo) {
        if (repo == null) {
            throw new IllegalArgumentException("repo is null");
        }
        if (this.has(new Repository[]{repo})) {
            log.warn("repository {} overwrites {}", (Object)repo, (Object)this.get(repo.name()));
        }
        try {
            repo.proxy().init();
        }
        catch (Exception e) {
            log.error("discarding repository " + repo.name() + " as it cannt be initialised (see cause)", (Throwable)e);
            return;
        }
        this.validate(repo);
        super.add((Object)repo);
        log.info("added repository: {}", (Object)repo, (Object)repo);
    }

    protected Repository remove(String name) {
        Repository repo = (Repository)super.remove(name);
        try {
            repo.proxy().shutdown();
        }
        catch (Throwable t) {
            log.warn("no clean shutdown for " + name + " (see cause)", t);
        }
        return repo;
    }

    public Repositories load() {
        ServiceLoader<VirtualPlugin> loaded = ServiceLoader.load(VirtualPlugin.class);
        List plugins = Apikit.streamof(loaded).collect(Collectors.toList());
        int current = this.size();
        for (VirtualPlugin plugin : plugins) {
            try {
                this.load(plugin);
            }
            catch (Throwable e) {
                log.error("plugin " + plugin.getClass() + " cannot be activated and will be discarded (see cause)", e);
            }
        }
        log.info(plugins.isEmpty() ? "no plugins found on classpath!" : "loaded {} repositories out of {} plugin(s)", (Object)(this.size() - current), (Object)plugins.size());
        return this;
    }

    public Set<Repository> sinks(AssetType ... types) {
        return this.elements().stream().filter(rec$ -> ((Repository)rec$).ingests(new AssetType[0])).collect(Collectors.toSet());
    }

    public Set<Repository> sources(AssetType ... types) {
        return this.elements().stream().filter(rec$ -> ((Repository)rec$).disseminates(new AssetType[0])).collect(Collectors.toSet());
    }

    public void shutdown() {
        this.forEach(xva$0 -> this.remove(new Repository[]{xva$0}));
        this.plugins.stream().forEach(p -> {
            try {
                this.shutdown();
            }
            catch (Throwable t) {
                log.warn("no clean shutdown for plugin " + p.getClass() + " (see cause)", t);
            }
        });
    }

    private void load(VirtualPlugin plugin) throws Exception {
        plugin.init();
        Collection<Repository> repos = plugin.repositories();
        if (repos == null || repos.isEmpty()) {
            log.error("plugin {} exports no repositories and will be ignored", plugin.getClass());
        } else {
            this.add(repos);
            this.plugins.add(plugin);
        }
    }

    private void validate(Repository repo) throws IllegalArgumentException {
        try {
            Objects.requireNonNull(repo.proxy().browser(), "browser");
            Objects.requireNonNull(repo.proxy().readers(), "readers");
            Objects.requireNonNull(repo.proxy().writers(), "writers");
            if (repo.proxy().readers().isEmpty() && repo.proxy().writers().isEmpty()) {
                throw new IllegalStateException("service defines no readers or writers");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid repository " + repo.name() + " (see cause)", e);
        }
    }
}

