/*
 * Decompiled with CFR 0.152.
 */
package it.eng.edison.usersurvey_portlet.server.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;

public class DocumentUpload
extends GenericPortlet {
    private static String ROOT_FOLDER_NAME = "/home/life/imageSurvey/";
    private static String ROOT_FOLDER_DESCRIPTION = "folder description";
    private static long PARENT_FOLDER_ID = 0L;

    public void uploadDocument(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException, PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this.createFolder(actionRequest, themeDisplay);
        this.fileUpload(themeDisplay, actionRequest);
    }

    public void downloadFiles(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException, PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Map urlMap = this.getAllFileLink(themeDisplay);
        actionRequest.setAttribute("urlMap", (Object)urlMap);
        actionResponse.setRenderParameter("jspPage", "/html/documentupload/download.jsp");
    }

    public Folder createFolder(ActionRequest actionRequest, ThemeDisplay themeDisplay) {
        boolean folderExist = this.isFolderExist(themeDisplay);
        Folder folder = null;
        if (!folderExist) {
            long repositoryId = themeDisplay.getScopeGroupId();
            try {
                ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFolder.class.getName(), (PortletRequest)actionRequest);
                folder = DLAppServiceUtil.addFolder((long)repositoryId, (long)PARENT_FOLDER_ID, (String)ROOT_FOLDER_NAME, (String)ROOT_FOLDER_DESCRIPTION, (ServiceContext)serviceContext);
            }
            catch (PortalException e1) {
                e1.printStackTrace();
            }
            catch (SystemException e1) {
                e1.printStackTrace();
            }
        }
        return folder;
    }

    public boolean isFolderExist(ThemeDisplay themeDisplay) {
        boolean folderExist = false;
        try {
            DLAppServiceUtil.getFolder((long)themeDisplay.getScopeGroupId(), (long)PARENT_FOLDER_ID, (String)ROOT_FOLDER_NAME);
            folderExist = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return folderExist;
    }

    public Folder getFolder(ThemeDisplay themeDisplay) {
        Folder folder = null;
        try {
            folder = DLAppServiceUtil.getFolder((long)themeDisplay.getScopeGroupId(), (long)PARENT_FOLDER_ID, (String)ROOT_FOLDER_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return folder;
    }

    public void fileUpload(ThemeDisplay themeDisplay, ActionRequest actionRequest) {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        String fileName = uploadPortletRequest.getFileName("uploadedFile");
        File file = uploadPortletRequest.getFile("uploadedFile");
        String mimeType = uploadPortletRequest.getContentType("uploadedFile");
        String title = fileName;
        String description = "This file is added via programatically";
        long repositoryId = themeDisplay.getScopeGroupId();
        try {
            Folder folder = this.getFolder(themeDisplay);
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
            FileInputStream is = new FileInputStream(file);
            DLAppServiceUtil.addFileEntry((long)repositoryId, (long)folder.getFolderId(), (String)fileName, (String)mimeType, (String)title, (String)description, (String)"", (InputStream)is, (long)file.getTotalSpace(), (ServiceContext)serviceContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, String> getAllFileLink(ThemeDisplay themeDisplay) {
        HashMap<String, String> urlMap = new HashMap<String, String>();
        long repositoryId = themeDisplay.getScopeGroupId();
        try {
            Folder folder = this.getFolder(themeDisplay);
            List fileEntries = DLAppServiceUtil.getFileEntries((long)repositoryId, (long)folder.getFolderId());
            for (FileEntry file : fileEntries) {
                String url = themeDisplay.getPortalURL() + themeDisplay.getPathContext() + "/documents/" + themeDisplay.getScopeGroupId() + "/" + file.getFolderId() + "/" + file.getTitle();
                urlMap.put(file.getTitle().split("\\.")[0], url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return urlMap;
    }
}

