/*
 * Decompiled with CFR 0.152.
 */
package it.eng.edison.usersurvey_portlet.server.util;

import it.eng.edison.usersurvey_portlet.server.entity.Survey;
import javax.servlet.http.HttpServletRequest;
import org.gcube.common.portal.mailing.EmailNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendEmailToUsers {
    private static final Logger _log = LoggerFactory.getLogger(SendEmailToUsers.class);

    public SendEmailToUsers() {
    }

    public SendEmailToUsers(Survey survey, String UrlWithoutParams, String uuid, String fullNameUser, String emailUser, String surveySender, String currentGroupName, String surveyAdminFullName, boolean isAnonymous, HttpServletRequest request) {
        this.sendInviteEmail(survey, UrlWithoutParams, uuid, fullNameUser, emailUser, surveySender, currentGroupName, surveyAdminFullName, isAnonymous, request);
    }

    public void sendInviteEmail(Survey survey, String UrlWithoutParams, String uuid, String fullNameUser, String email, String surveySender, String currentGroupName, String surveyAdminFullName, boolean isAnonymous, HttpServletRequest request) throws IllegalArgumentException {
        String emailSubject = "You have been invited to fill a survey on " + currentGroupName;
        EmailNotification mailToSend = new EmailNotification(email, emailSubject, this.getTextEmail(UrlWithoutParams, uuid, fullNameUser, email, surveySender, currentGroupName, surveyAdminFullName, isAnonymous), request);
        mailToSend.sendEmail();
    }

    private String getTextEmail(String UrlWithoutParams, String uuid, String fullNameUser, String email, String surveySender, String currentGroupName, String surveyAdminFullName, boolean isAnonymous) {
        StringBuilder body = new StringBuilder();
        body.append("Dear " + fullNameUser + ",").append("<br><br>").append(surveySender + " invited to partecipate a survey in the context of <b>" + currentGroupName + "</b>.").append("<br><br>");
        body.append("To participate this survey, please follow this <a href=\"" + UrlWithoutParams + "?UUID=" + uuid + "\">link</a>.");
        body.append("<br><br>").append("Thank you very much for your time and cooperation.").append("<br><br>");
        if (isAnonymous) {
            body.append("<br><br>").append("Please note: your participation in the survey is completely voluntary and all of your responses will be kept confidential. <br> The access code in the link is to remove you from the list once you have completed the survey. <br> No personally identifiable information will be associated with your responses to any reports of these data.");
        }
        return body.toString();
    }
}

