/*
 * Decompiled with CFR 0.152.
 */
package it.eng.edison.messages.server.util;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;

public class EdisonMessagesUploadServlet
extends HttpServlet {
    private String pathImage = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.pathImage = config.getInitParameter("pathImage");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                int len;
                if (item.isFormField()) continue;
                String fieldName = item.getFieldName();
                String fileName = item.getName();
                if (fileName != null) {
                    fileName = FilenameUtils.getName((String)fileName);
                }
                String contentType = item.getContentType();
                boolean isInMemory = item.isInMemory();
                long sizeInBytes = item.getSize();
                byte[] data = item.get();
                fileName = this.pathImage + fileName;
                FileOutputStream fileOutSt = new FileOutputStream(fileName);
                fileOutSt.write(data);
                fileOutSt.close();
                ByteArrayInputStream is = new ByteArrayInputStream(contentType.getBytes());
                ServletOutputStream out = response.getOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = is.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                ((InputStream)is).close();
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            System.out.println("File Uploading Failed!" + e.getMessage());
            e.printStackTrace();
        }
    }
}

