//alert("running pie.js");


function addPieChart(divID, dataJSON, showLabels, showLegend, type){
	var data = JSON.parse(dataJSON);
	if(type=="simple"){//Regular pie chart
		nv.addGraph(function() {
		  var chart = nv.models.pieChart()
		      .x(function(d) { return d.label })
		      .y(function(d) { return d.value })
		      .showLabels(showLabels).showLegend(showLegend);
		
		    d3.select("#"+divID+" svg")
		        .datum(data)
		        .transition().duration(700)
		        .call(chart);
		
		    chart.pie.dispatch.on('elementClick', function(e){
				if(e.point.url != undefined)
			    	window.location.href = e.point.url;
			});
		    
		    nv.utils.windowResize(chart.update);
		    
			$("#"+divID).resize(function() {
		  		chart.update();
			});
		    
		  return chart;
		});
	}
	else{
		nv.addGraph(function() {
			  var chart = nv.models.pieChart()
			      .x(function(d) { return d.label })
			      .y(function(d) { return d.value })
			      .showLabels(showLabels)     //Display pie labels
			      .showLegend(showLegend)
			      .labelThreshold(.05)  //Configure the minimum slice size for labels to show up
			      .labelType("value") //Configure what type of data to show in the label. Can be "key", "value" or "percent"
			      .donut(true)          //Turn on Donut mode. Makes pie chart look tasty!
			      .donutRatio(0.35);     //Configure how big you want the donut hole size to be.

			    d3.select("#"+divID+" svg")
			        .datum(data)
			        .transition().duration(700)
			        .call(chart);

			    chart.pie.dispatch.on('elementClick', function(e){
					if(e.point.url != undefined)
				    	window.location.href = e.point.url;
				});
			    
			    nv.utils.windowResize(chart.update);
			    
				$("#"+divID).resize(function() {
			  		chart.update();
				});
			    
			  return chart;
			});
	}
}


/*
//Donut chart
nv.addGraph(function() {
  var chart = nv.models.pieChart()
      .x(function(d) { return d.label })
      .y(function(d) { return d.value })
      .showLabels(true)     //Display pie labels
      .labelThreshold(.05)  //Configure the minimum slice size for labels to show up
      .labelType("percent") //Configure what type of data to show in the label. Can be "key", "value" or "percent"
      .donut(true)          //Turn on Donut mode. Makes pie chart look tasty!
      .donutRatio(0.35)     //Configure how big you want the donut hole size to be.
      ;

    d3.select("#chart2 svg")
        .datum(exampleData())
        .transition().duration(350)
        .call(chart);

  return chart;
});
*/


//Pie chart example data. Note how there is only a single array of key-value pairs.
//function exampleData() {
//  return  [
//      { 
//        "label": "One",
//        "value" : 29.765957771107
//      } , 
//      { 
//        "label": "Two",
//        "value" : 0
//      } , 
//      { 
//        "label": "Three",
//        "value" : 32.807804682612
//      } , 
//      { 
//        "label": "Four",
//        "value" : 196.45946739256
//      } , 
//      { 
//        "label": "Five",
//        "value" : 0.19434030906893
//      } , 
//      { 
//        "label": "Six",
//        "value" : 98.079782601442
//      } , 
//      { 
//        "label": "Seven",
//        "value" : 13.925743130903
//      } , 
//      { 
//        "label": "Eight",
//        "value" : 5.1387322875705
//      }
//    ];
//}


