/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.filters;

import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSet;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSetManipulator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.filters.DataSetFilterApplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class DataSetFilterApplierImpl
extends DataSetManipulator
implements DataSetFilterApplier {
    @Override
    public void applyFilters(DataSet dataSet, Map<String, String> filters) throws Exception {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> filter : filters.entrySet()) {
            HashSet filterValues;
            String filterField = filter.getKey();
            int filterFieldIndex = -1;
            if (filterField == null || (filterFieldIndex = this.getFieldIndex(dataSet, filterField)) == -1) {
                throw new Exception("Invalid data field provided " + filterField);
            }
            String filterValue = filter.getValue();
            if (filterValue == null || (filterValues = new HashSet(Arrays.stream(filterValue.split(";")).map(x -> x.toLowerCase()).collect(Collectors.toList()))).isEmpty()) continue;
            ArrayList<List<String>> results = new ArrayList<List<String>>();
            for (List<String> row : dataSet.getData()) {
                String value = row.get(filterFieldIndex);
                if (!filterValues.contains(value.toLowerCase())) continue;
                results.add(row);
            }
            dataSet.setData(results);
        }
    }
}

