/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors;

import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSet;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSetManipulator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.ThreeDData;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors.ThreeDDataExtractor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ThreeDDataExtractorImpl
extends DataSetManipulator
implements ThreeDDataExtractor {
    @Override
    public ThreeDData extract(DataSet dataSet, String xAxisField, String yAxisField, String zAxisField) throws Exception {
        int xAxisFieldIndex = -1;
        if (xAxisField == null || (xAxisFieldIndex = this.getFieldIndex(dataSet, xAxisField)) == -1) {
            throw new Exception("Invalid data field provided " + xAxisField);
        }
        int yAxisFieldIndex = -1;
        if (yAxisField == null || (yAxisFieldIndex = this.getFieldIndex(dataSet, yAxisField)) == -1) {
            throw new Exception("Invalid data field provided " + yAxisField);
        }
        int zAxisFieldIndex = -1;
        if (zAxisField == null || (zAxisFieldIndex = this.getFieldIndex(dataSet, zAxisField)) == -1) {
            throw new Exception("Invalid data field provided " + zAxisField);
        }
        return this.extract(dataSet, xAxisFieldIndex, yAxisFieldIndex, zAxisFieldIndex);
    }

    private ThreeDData extract(DataSet dataSet, int xAxisFieldIndex, int yAxisFieldIndex, int zAxisFieldIndex) {
        ThreeDData threeDData = new ThreeDData();
        ArrayList<BigDecimal> xAxisData = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> yAxisData = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> zAxisData = new ArrayList<BigDecimal>();
        for (List<String> row : dataSet.getData()) {
            BigDecimal xValue = this.parseBigDecimal(row.get(xAxisFieldIndex));
            BigDecimal yValue = this.parseBigDecimal(row.get(yAxisFieldIndex));
            BigDecimal zValue = this.parseBigDecimal(row.get(zAxisFieldIndex));
            if (xValue == null || yValue == null || zValue == null) continue;
            xAxisData.add(xValue);
            yAxisData.add(yValue);
            zAxisData.add(zValue);
        }
        threeDData.setXAxis(xAxisData);
        threeDData.setYAxis(yAxisData);
        threeDData.setZAxis(zAxisData);
        return threeDData;
    }
}

