package gr.i2s.bluebridge.simul.model.util;

import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gr.i2s.bluebridge.simul.model.ScenarioFull;
import gr.i2s.bluebridge.simul.util2.HibernateUtil;

public class ScenarioFullUtil {
	public static void add(ScenarioFull scenarioFull) throws Exception {
		ScenarioUtil.add(scenarioFull);
	}

	public static void update(ScenarioFull scenarioFull) throws Exception {
		ScenarioUtil.update(scenarioFull);
	}

	public static void delete(long id) throws Exception {
		ScenarioUtil.delete(id);
	}

	public static ScenarioFull getScenarioFull(long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			ScenarioFull scenarioFull = (ScenarioFull) session.get(ScenarioFull.class, Long.valueOf(id));

			session.getTransaction().commit();

			return scenarioFull;
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static List getScenarioFulls(String userId, int start, int end) throws Exception {
		if (logger.isTraceEnabled()) {
			logger.trace(String.format("reading %s for %s start %s end %s", "ScenarioFull", userId, start, end));
		}

		Session session = null;

		try {
			logger.trace(String.format("denispyr start getScenarioFulls"));
			session = HibernateUtil.openSession();
			logger.trace(String.format("denispyr session [%s]", session));

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_USERID).setParameter("userid", userId);
			if (start > 0)
				q.setFirstResult(start);
			if (end > 0) {
				if (end < start)
					end = start + 1;
				q.setMaxResults(end - start);
			}

			List list = q.list();

			session.getTransaction().commit();

			logger.trace(String.format("denispyr return ScenarioFulls %s", list));
			return list;
		} catch (Exception e) {
			logger.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static List getScenarioFulls(String userId) throws Exception {
		Session session = null;

		try {
			logger.trace(String.format("denispyr start getScenarioFulls"));
			session = HibernateUtil.openSession();
			logger.trace(String.format("denispyr session [%s]", session));

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_USERID).setParameter("userid", userId);

			List list = q.list();

			session.getTransaction().commit();

			logger.trace(String.format("denispyr return ScenarioFulls %s", list));
			return list;
		} catch (Exception e) {
			logger.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static int getScenarioFullCount(String userId) throws Exception {
		Session session = null;

		try {
			logger.trace(String.format("denispyr start getScenarioFulls"));
			session = HibernateUtil.openSession();
			logger.trace(String.format("denispyr session [%s]", session));

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_USERID_COUNT).setParameter("userid", userId);

			Number count = (Number) q.uniqueResult();

			session.getTransaction().commit();

			logger.trace(String.format("denispyr return count %s", count));
			return count.intValue();
		} catch (Exception e) {
			logger.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	// private static final String _GET_ALL_ON_USERID = "SELECT
	// {ScenarioFullView.*}
	// FROM ScenarioFullView WHERE userid = :userid ORDER BY designation ASC";
	private static final String _GET_ALL_ON_USERID = "FROM gr.i2s.bluebridge.simul.model.ScenarioFull s WHERE s.userId = :userid ORDER BY s.designation ASC";
	private static final String _GET_ALL_ON_USERID_COUNT = "SELECT count(*) FROM gr.i2s.bluebridge.simul.model.ScenarioFull s WHERE s.userId = :userid";
	private static Log logger = LogFactoryUtil.getLog(ScenarioFullUtil.class);
}
