-- LONG <- INTEGER(11)

-- TABLES

create table BroodstockQuality (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	aa INTEGER,
	designation VARCHAR(75) null
);

create table CurrentRating (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	aa INTEGER,
	designation VARCHAR(75) null
);

create table Fcr (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	simulModelId INTEGER(11),
	temperature INTEGER,
	fromWeight DOUBLE,
	value DOUBLE
);

create table FeedQuality (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	aa INTEGER,
	designation VARCHAR(75) null
);

create table Mortality (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	simulModelId INTEGER(11),
	temperature INTEGER,
	fromWeight DOUBLE,
	value DOUBLE
);

create table OxygenRating (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	aa INTEGER,
	designation VARCHAR(75) null
);

create table Region (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	designation VARCHAR(75) null
);

create table Scenario (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	designation VARCHAR(75) null,
	comments VARCHAR(75) null,
	simulModelId INTEGER(11),
	startDate DATE null,
	fishNo INTEGER,
	weight DOUBLE,
	targetDate DATE null,
	resultsWeight DOUBLE,
	resultsGrowth DOUBLE,
	resultsEconFCR DOUBLE,
	resultsBiolFCR DOUBLE,
	resultsSGR DOUBLE,
	resultsMortality DOUBLE,
	resultsGraphData VARCHAR(75) null
);


create table Sfr (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	simulModelId INTEGER(11),
	temperature INTEGER,
	fromWeight DOUBLE,
	value DOUBLE
);

create table Sgr (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	simulModelId INTEGER(11),
	temperature INTEGER,
	fromWeight DOUBLE,
	value DOUBLE
);

create table SimulModel (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	designation VARCHAR(75) null,
	comments VARCHAR(75) null,
	speciesId INTEGER(11),
	siteId INTEGER(11),
	broodstockQualityId INTEGER(11),
	broodstockGeneticImprovement BOOLEAN,
	feedQualityId INTEGER(11)
);


create table Site (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	designation VARCHAR(75) null,
	periodJanA INTEGER,
	periodJanB INTEGER,
	periodFebA INTEGER,
	periodFebB INTEGER,
	periodMarA INTEGER,
	periodMarB INTEGER,
	periodAprA INTEGER,
	periodAprB INTEGER,
	periodMayA INTEGER,
	periodMayB INTEGER,
	periodJunA INTEGER,
	periodJunB INTEGER,
	periodJulA INTEGER,
	periodJulB INTEGER,
	periodAugA INTEGER,
	periodAugB INTEGER,
	periodSepA INTEGER,
	periodSepB INTEGER,
	periodOctA INTEGER,
	periodOctB INTEGER,
	periodNovA INTEGER,
	periodNovB INTEGER,
	periodDecA INTEGER,
	periodDecB INTEGER,
	oxygenRatingId INTEGER(11),
	currentRatingId INTEGER(11),
	regionId INTEGER(11)
);

create table Species (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	designation VARCHAR(75) null
);

-- VIEWS

drop view SimulModelFullView;
create view SimulModelFullView as (
select 
	sm.*,
	sp.designation as speciesDesignation,
	si.designation as siteDesignation,
	bq.designation as broodstockQualityDesignation,
	fq.designation as feedQualityDesignation
from 
	SimulModel sm
	join Species sp on (sm.id=sp.id)
	join Site si on (sm.siteId=si.id)
	join BroodstockQuality bq on (sm.id=bq.id)
	join FeedQuality fq on (sm.id=fq.id)
);

drop view ScenarioFullView;
create view ScenarioFullView as (
select 
	sn.*,
	sm.designation as simulModelDesignation
from 
	Scenario sn
	join SimulModel sm on (sn.simulModelId=sm.id)
);

drop view SiteFullView;
create view SiteFullView as (
select 
	si.*,
	rg.designation as regionDesignation,
	oxr.designation as oxygenRatingDesignation,
	cr.designation as currentRatingDesignation
from 
	Site si
	join Region rg on (si.id=rg.id)
	join OxygenRating oxr on (si.id=oxr.id)
	join CurrentRating cr on (si.id=cr.id)
);

