/*
 * Decompiled with CFR 0.152.
 */
package gr.i2s.bluebridge.simul.portlet;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.bridges.mvc.MVCPortlet;
import gr.i2s.bluebridge.simul.model.Modeler;
import gr.i2s.bluebridge.simul.model.util.BroodstockQualityUtil;
import gr.i2s.bluebridge.simul.model.util.FeedQualityUtil;
import gr.i2s.bluebridge.simul.model.util.ModelerFullUtil;
import gr.i2s.bluebridge.simul.model.util.ModelerUtil;
import gr.i2s.bluebridge.simul.model.util.SiteFullUtil;
import gr.i2s.bluebridge.simul.model.util.SpeciesUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class ModelerPortlet
extends MVCPortlet {
    private static Log logger = LogFactoryUtil.getLog(ModelerPortlet.class);

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        logger.info((Object)String.format("render path [%s]", this.getPath((PortletRequest)request)));
        String path = this.getPath((PortletRequest)request);
        if (path == null || path.endsWith("view.jsp")) {
            logger.trace((Object)"Preparing view");
            String userId = null;
            try {
                ServiceContext context = ServiceContextFactory.getInstance((PortletRequest)request);
                userId = String.valueOf(context.getUserId());
            }
            catch (PortalException | SystemException e) {
                e.printStackTrace();
            }
            request.setAttribute("userId", (Object)userId);
        } else if (path.endsWith("edit.jsp")) {
            logger.trace((Object)"Preparing edit");
            String userId = null;
            try {
                ServiceContext context = ServiceContextFactory.getInstance((PortletRequest)request);
                userId = String.valueOf(context.getUserId());
            }
            catch (PortalException | SystemException e) {
                e.printStackTrace();
            }
            ArrayList specieList = null;
            ArrayList siteList = null;
            ArrayList broodstockQualityList = null;
            ArrayList feedQualityList = null;
            try {
                specieList = new ArrayList(SpeciesUtil.getSpecieses());
                siteList = new ArrayList(SiteFullUtil.getSiteFulls((String)userId));
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)String.format("Site count %s full %s", siteList.size(), new ArrayList(SiteFullUtil.getSiteFulls((String)userId).size())));
                }
                broodstockQualityList = new ArrayList(BroodstockQualityUtil.getBroodstockQualities());
                feedQualityList = new ArrayList(FeedQualityUtil.getFeedQualities());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (specieList == null) {
                specieList = new ArrayList();
            }
            request.setAttribute("specieList", specieList);
            if (siteList == null) {
                siteList = new ArrayList();
            }
            request.setAttribute("siteList", siteList);
            if (broodstockQualityList == null) {
                broodstockQualityList = new ArrayList();
            }
            request.setAttribute("broodstockQualityList", broodstockQualityList);
            if (feedQualityList == null) {
                feedQualityList = new ArrayList();
            }
            request.setAttribute("feedQualityList", feedQualityList);
        } else {
            logger.trace((Object)"Preparing nothing!");
        }
        super.render(request, response);
    }

    public void save(ActionRequest request, ActionResponse response) throws Exception {
        ServiceContext context = ServiceContextFactory.getInstance((PortletRequest)request);
        Long id = ParamUtil.getLong((PortletRequest)request, (String)"id");
        Modeler modeler = id > 0L ? ModelerUtil.getModeler((long)id) : new Modeler();
        String designation = ParamUtil.getString((PortletRequest)request, (String)"designation");
        String comments = ParamUtil.getString((PortletRequest)request, (String)"comments");
        Long speciesId = ParamUtil.getLong((PortletRequest)request, (String)"speciesId");
        Long siteId = ParamUtil.getLong((PortletRequest)request, (String)"siteId");
        Long broodstockQualityId = ParamUtil.getLong((PortletRequest)request, (String)"broodstockQualityId");
        Boolean broodstockGeneticImprovement = ParamUtil.get((PortletRequest)request, (String)"broodstockGeneticImprovement", (boolean)false);
        Long feedQualityId = ParamUtil.getLong((PortletRequest)request, (String)"feedQualityId");
        String[] filenames = new String[]{modeler.getUploadFilename1(), modeler.getUploadFilename2(), modeler.getUploadFilename3(), modeler.getUploadFilename4()};
        File[] files = new File[4];
        int i = 1;
        while (i <= 4) {
            String action = ParamUtil.getString((PortletRequest)request, (String)String.format("fileUploadAction%s", i));
            if (action.equals("keep")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("for upload [%s] the action is [keep] so I do nothing", i));
                }
            } else if (action.equals("delete")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("for upload [%s] the action is [delete] so I will delete the KPIs and clear the modeler fields", i));
                }
                filenames[i - 1] = "";
                files[i - 1] = null;
                ModelerUtil.cleanKPIs((long)id, (int)i);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("for upload [%s] the action is [replace] so I will upload a file", i));
                }
                String fileInputName = String.format("fileUpload%s", i);
                UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest((PortletRequest)request);
                long sizeInBytes = uploadRequest.getSize(fileInputName);
                File uploadedFile = uploadRequest.getFile(fileInputName);
                String sourceFileName = uploadRequest.getFileName(fileInputName);
                if (uploadRequest.getSize(fileInputName) == 0L) {
                    logger.warn((Object)String.format("Bypassing 0 bytes file: [%s]", sourceFileName));
                } else {
                    if (!Strings.isNullOrEmpty((String)filenames[i - 1])) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("the user replaces the file for [%s] so I will clear the old KPIs", i));
                        }
                        ModelerUtil.cleanKPIs((long)id, (int)i);
                    }
                    File targetFile = File.createTempFile("gr_i2s_simul_", "." + Files.getFileExtension((String)uploadedFile.getName()));
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)String.format("I will try to save as [%s]", targetFile.getAbsolutePath()));
                    }
                    if (targetFile.getUsableSpace() < sizeInBytes) {
                        throw new Exception(String.format("Out of disk space! I have [%s] available while I need [%s]", targetFile.getUsableSpace(), sizeInBytes));
                    }
                    Files.copy((File)uploadedFile, (File)targetFile);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("copied [%s] as [%s]", sourceFileName, targetFile));
                    }
                    filenames[i - 1] = sourceFileName;
                    files[i - 1] = targetFile;
                }
            }
            ++i;
        }
        modeler.setDesignation(designation);
        modeler.setComments(comments);
        modeler.setSpeciesId(speciesId.longValue());
        modeler.setSiteId(siteId.longValue());
        modeler.setBroodstockQualityId(broodstockQualityId.longValue());
        modeler.setBroodstockGeneticImprovement(broodstockGeneticImprovement.booleanValue());
        modeler.setFeedQualityId(feedQualityId.longValue());
        modeler.setUserId(String.valueOf(context.getUserId()));
        modeler.setUploadFilename1(filenames[0]);
        modeler.setUploadFilename2(filenames[1]);
        modeler.setUploadFilename3(filenames[2]);
        modeler.setUploadFilename4(filenames[3]);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("persisting %s", modeler));
        }
        if (id > 0L) {
            ModelerUtil.update((Modeler)modeler);
        } else {
            ModelerUtil.add((Modeler)modeler);
        }
    }

    public void delete(ActionRequest request, ActionResponse response) throws Exception {
        long id = ParamUtil.getLong((PortletRequest)request, (String)"id");
        logger.debug((Object)String.format("Deleting modeler [%s]", id));
        ModelerFullUtil.delete((long)id);
    }
}

