package gr.i2s.bluebridge.simul.util2;

import java.util.List;

import org.hibernate.SQLQuery;
import org.hibernate.Session;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gr.i2s.bluebridge.simul.model2.Foo;

public class FooUtil {
	public static void addFoo(Foo foo) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			session.save(foo);

			session.flush();

			session.getTransaction().commit();
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static void deleteFoo(long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			Foo foo = (Foo) session.get(Foo.class, Long.valueOf(id));

			if (foo != null) {
				session.delete(foo);

				session.flush();
			}

			session.getTransaction().commit();
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static Foo getFoo(long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			Foo foo = (Foo) session.get(Foo.class, Long.valueOf(id));

			session.getTransaction().commit();

			return foo;
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static List getFoos() throws Exception {
		Session session = null;

		try {
			_log.trace(String.format("denispyr start getFoos"));
			session = HibernateUtil.openSession();
			_log.trace(String.format("denispyr session [%s]", session));

			session.beginTransaction();

			SQLQuery q = session.createSQLQuery(_GET_FOOD_ITEMS);

			q.addEntity("Foo", Foo.class);

			List list = q.list();

			session.getTransaction().commit();

			_log.trace(String.format("denispyr return Foos %s", list));
			return list;
		} catch (Exception e) {
			_log.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static void updateFoo(Foo foo) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			session.update(foo);

			session.flush();

			session.getTransaction().commit();
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	private static final String _GET_FOOD_ITEMS = "SELECT {Foo.*} FROM Foo ORDER BY designation ASC";
	private static Log _log = LogFactoryUtil.getLog(FooUtil.class);
}
