package gr.i2s.bluebridge.simul.model.util;

import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gr.i2s.bluebridge.simul.model.Scenario;
import gr.i2s.bluebridge.simul.util2.HibernateUtil;

public class ScenarioUtil {
	public static void add(Scenario scenario) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			session.save(scenario);

			session.flush();

			session.getTransaction().commit();
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static void update(Scenario scenario) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			session.update(scenario);

			session.flush();

			session.getTransaction().commit();
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static void delete(long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			Scenario scenario = (Scenario) session.get(Scenario.class, Long.valueOf(id));

			if (scenario != null) {
				session.delete(scenario);

				session.flush();
			}

			session.getTransaction().commit();
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static Scenario getScenario(long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			Scenario scenario = (Scenario) session.get(Scenario.class, Long.valueOf(id));

			session.getTransaction().commit();

			return scenario;
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static List getScenarios(String userId) throws Exception {
		Session session = null;

		try {
			logger.trace(String.format("denispyr start getScenarios"));
			session = HibernateUtil.openSession();
			logger.trace(String.format("denispyr session [%s]", session));

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_USERID).setParameter("userid", userId);

			List list = q.list();

			session.getTransaction().commit();

			logger.trace(String.format("denispyr return Scenarios %s", list));
			return list;
		} catch (Exception e) {
			logger.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	private static final String _GET_ALL_ON_USERID = "FROM gr.i2s.bluebridge.simul.model.Scenario s WHERE s.userId = :userid ORDER BY s.designation ASC";
	private static Log logger = LogFactoryUtil.getLog(ScenarioUtil.class);
}
