/*
 * Decompiled with CFR 0.152.
 */
package gr.i2s.bluebridge.simul.calc;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Ordering;
import com.google.common.collect.RangeMap;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import gr.i2s.bluebridge.simul.calc.ScenarioExecutor;
import gr.i2s.bluebridge.simul.model.Fcr;
import gr.i2s.bluebridge.simul.model.Mortality;
import gr.i2s.bluebridge.simul.model.Scenario;
import gr.i2s.bluebridge.simul.model.Sfr;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class ScenarioExecutor {
    private static final Log logger = LogFactoryUtil.getLog(ScenarioExecutor.class);
    private static final SimpleDateFormat FULL_DATE_FORMAT = new SimpleDateFormat("YYYYMMdd-Hms-S");
    Ordering<Fcr> fcrByTempWeight = new /* Unavailable Anonymous Inner Class!! */;
    Ordering<Sfr> sfrByTempWeight = new /* Unavailable Anonymous Inner Class!! */;
    Ordering<Mortality> mortalityByTempWeight = new /* Unavailable Anonymous Inner Class!! */;
    private final Scenario mScenario;
    private final Map<Integer, RangeMap<Double, Double>> fcrTable;
    private final Map<Integer, RangeMap<Double, Double>> sfrTable;
    private final Map<Integer, RangeMap<Double, Double>> mortalityTable;
    private final Map<Long, Integer> temperatureTable;
    private final Integer[] modelTemperature;
    private final Queue<Daily> dailyResults;

    public ScenarioExecutor(Scenario scenario) {
        this.mScenario = scenario;
        this.fcrTable = new HashMap();
        this.sfrTable = new HashMap();
        this.mortalityTable = new HashMap();
        this.temperatureTable = new HashMap();
        this.modelTemperature = new Integer[24];
        this.dailyResults = new LinkedList();
    }

    public void run() {
        this.beforeRun();
        this.doRun();
        this.afterRun();
    }

    private void beforeRun() {
    }

    private void afterRun() {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("logger", (Object)logger).add("mScenario", (Object)this.mScenario).add("fcrTable", (Object)this.fcrTable).add("sfrTable", (Object)this.sfrTable).add("mortalityTable", (Object)this.mortalityTable).add("temperatureTable", (Object)this.temperatureTable).add("modelTemperature", (Object)Arrays.deepToString(new Object[]{this.modelTemperature})).add("dailyResults", (Object)Arrays.deepToString(new Object[]{this.dailyResults})).toString();
    }

    private void doRun() {
        long start = System.currentTimeMillis();
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(this.mScenario.getStartDate());
        startDate.set(10, 0);
        startDate.set(12, 0);
        startDate.set(13, 0);
        startDate.set(14, 0);
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(this.mScenario.getTargetDate());
        endDate.set(10, 0);
        endDate.set(12, 0);
        endDate.set(13, 0);
        endDate.set(14, 0);
        double startBM = this.mScenario.getWeight() * (double)this.mScenario.getFishNo();
        double totalFood = 0.0;
        double totalDeadBM = 0.0;
        int totalDead = 0;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("temperatureTable %s", this.temperatureTable));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("sfrTable %s", this.sfrTable));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("fcrTable %s", this.fcrTable));
        }
        Daily curDay = new Daily(this);
        curDay.mab = this.mScenario.getWeight();
        curDay.fishcount = this.mScenario.getFishNo();
        Calendar curDate = startDate;
        while (!curDate.after(endDate)) {
            double dayBM;
            Double dBM;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("on day [%s] as millis [%s]", FULL_DATE_FORMAT.format(curDate.getTime()), curDate.getTimeInMillis()));
            }
            curDay.date.setTimeInMillis(curDate.getTimeInMillis());
            curDay.dead = 0;
            curDay.food = 0.0;
            curDay.growth = 0.0;
            Integer temperature = (Integer)this.temperatureTable.get(curDay.date.getTimeInMillis());
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("temperature %s", temperature));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("sfr temperature [%s] selection %s", temperature, this.sfrTable.get(temperature)));
            }
            curDay.temperature = temperature;
            Double sfr = (Double)((RangeMap)this.sfrTable.get(temperature)).get((Comparable)curDay.mab);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("sfr on mab [%s] selection %s", curDay.mab, sfr));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("fcr temperature [%s] selection %s", temperature, this.fcrTable.get(temperature)));
            }
            curDay.sfr = sfr * 100.0;
            Double fcr = (Double)((RangeMap)this.fcrTable.get(temperature)).get((Comparable)curDay.mab);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("fcr on mab [%s] selection %s", curDay.mab, fcr));
            }
            curDay.fcr = fcr * 100.0;
            curDay.dead = (int)((Double)((RangeMap)this.mortalityTable.get(temperature)).get((Comparable)curDay.mab) * (double)curDay.fishcount.intValue());
            curDay.deadBM = (double)curDay.dead.intValue() * curDay.mab;
            totalDead += curDay.dead.intValue();
            totalDeadBM += curDay.deadBM.doubleValue();
            Daily daily = curDay;
            Integer.valueOf(daily.fishcount - curDay.dead);
            daily.fishcount = daily.fishcount;
            curDay.food = curDay.mab * (double)curDay.fishcount.intValue() * sfr;
            totalFood += curDay.food.doubleValue();
            double foodPerFish = curDay.food / (double)curDay.fishcount.intValue();
            curDay.growth = fcr > 0.0 ? foodPerFish / (fcr * 100.0) : 0.0;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("adding daily [%s]", curDay));
            }
            curDay.fcrEcon = (dBM = Double.valueOf((dayBM = curDay.mab * (double)curDay.fishcount.intValue()) - startBM)) > 0.0 ? totalFood / dBM : 0.0;
            dBM = dBM - totalDeadBM;
            curDay.fcrBiol = dBM > 0.0 ? totalFood / dBM : 0.0;
            this.dailyResults.add(curDay);
            Daily prevDay = curDay;
            Daily daily2 = curDay = new Daily(this, prevDay);
            Double.valueOf(daily2.mab + prevDay.growth);
            daily2.mab = daily2.mab;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("prevDay [%s] curDay [%s]", prevDay, curDay));
            }
            prevDay = null;
            curDate.add(5, 1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("final day [%s]", curDay));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("detailed daily results [%s]", this.dailyResults));
        }
        double finalBM = curDay.mab * (double)curDay.fishcount.intValue();
        this.mScenario.setResultsWeight(curDay.mab.doubleValue());
        Double dBMEcon = finalBM - startBM;
        this.mScenario.setResultsEconFCR(dBMEcon > 0.0 ? totalFood / dBMEcon : 0.0);
        Double dBMBiol = dBMEcon - totalDeadBM;
        this.mScenario.setResultsBiolFCR(dBMBiol > 0.0 ? totalFood / dBMBiol : 0.0);
        this.mScenario.setResultsMortality(100.0 * ((double)totalDead / (double)this.mScenario.getFishNo()));
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        String tableWeight = new String();
        String tableFCR = new String();
        String tableFood = new String();
        String recordWeight = "{c:[{v: '%s'}, {v: %.2f}]},";
        String recordFCR = "{c:[{v: '%s'}, {v: %.2f}, {v: %.2f}]},";
        String recordFood = "{c:[{v: '%s-%s'}, {v: %.2f}]},";
        int foodMonth = -1;
        int foodYear = -1;
        double foodCons = 0.0;
        for (Daily daily : this.dailyResults) {
            String day = dateFormat.format(daily.date.getTime());
            tableWeight = tableWeight + String.format(recordWeight, day, daily.mab);
            if (daily.fcrBiol > 0.0) {
                tableFCR = tableFCR + String.format(recordFCR, day, daily.fcrBiol, daily.fcrEcon);
            }
            if (foodMonth != daily.date.get(2) || foodYear != daily.date.get(1)) {
                if (foodCons > 0.0) {
                    tableFood = tableFood + String.format(recordFood, foodMonth + 1, foodYear, foodCons / 1000.0);
                }
                foodCons = 0.0;
                foodMonth = daily.date.get(2);
                foodYear = daily.date.get(1);
            }
            foodCons += curDay.food.doubleValue();
        }
        if (foodCons > 0.0) {
            tableFood = tableFood + String.format(recordFood, foodMonth + 1, foodYear, foodCons / 1000.0);
        }
        this.mScenario.setResultsGraphData(tableWeight + "gri2sbbridge" + tableFCR + "gri2sbbridge" + tableFood);
        long duration = System.currentTimeMillis() - start;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("actual run took [%s] ms", duration));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("results [%s]", this.mScenario));
        }
    }

    static /* synthetic */ SimpleDateFormat access$000() {
        return FULL_DATE_FORMAT;
    }
}

