-- LONG <- INTEGER(11)

create table BroodstockQuality (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	aa INTEGER,
	designation VARCHAR(75) null
);

create table CurrentRating (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	aa INTEGER,
	designation VARCHAR(75) null
);

create table Fcr (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	simulModelId INTEGER(11),
	temperature INTEGER,
	fromWeight DOUBLE,
	value DOUBLE
);

create table FeedQuality (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	aa INTEGER,
	designation VARCHAR(75) null
);

create table Mortality (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	simulModelId INTEGER(11),
	temperature INTEGER,
	fromWeight DOUBLE,
	value DOUBLE
);

create table OxygenRating (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	aa INTEGER,
	designation VARCHAR(75) null
);

create table Region (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	designation VARCHAR(75) null
);

create table Scenario (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	designation VARCHAR(75) null,
	comments VARCHAR(75) null,
	simulModelId INTEGER(11),
	startDate DATE null,
	fishNo INTEGER,
	weight DOUBLE,
	targetDate DATE null,
	resultsWeight DOUBLE,
	resultsGrowth DOUBLE,
	resultsEconFCR DOUBLE,
	resultsBiolFCR DOUBLE,
	resultsSGR DOUBLE,
	resultsMortality DOUBLE,
	resultsGraphData VARCHAR(75) null
);


create table Sfr (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	simulModelId INTEGER(11),
	temperature INTEGER,
	fromWeight DOUBLE,
	value DOUBLE
);

create table Sgr (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	simulModelId INTEGER(11),
	temperature INTEGER,
	fromWeight DOUBLE,
	value DOUBLE
);

create table SimulModel (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	designation VARCHAR(75) null,
	comments VARCHAR(75) null,
	speciesId INTEGER(11),
	siteId INTEGER(11),
	broodstockQualityId INTEGER(11),
	broodstockGeneticImprovement BOOLEAN,
	feedQualityId INTEGER(11)
);


create table Site (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	designation VARCHAR(75) null,
	periodJanA INTEGER,
	periodJanB INTEGER,
	periodFebA INTEGER,
	periodFebB INTEGER,
	periodMarA INTEGER,
	periodMarB INTEGER,
	periodAprA INTEGER,
	periodAprB INTEGER,
	periodMayA INTEGER,
	periodMayB INTEGER,
	periodJunA INTEGER,
	periodJunB INTEGER,
	periodJulA INTEGER,
	periodJulB INTEGER,
	periodAugA INTEGER,
	periodAugB INTEGER,
	periodSepA INTEGER,
	periodSepB INTEGER,
	periodOctA INTEGER,
	periodOctB INTEGER,
	periodNovA INTEGER,
	periodNovB INTEGER,
	periodDecA INTEGER,
	periodDecB INTEGER,
	oxygenRatingId INTEGER(11),
	currentRatingId INTEGER(11),
	regionId INTEGER(11)
);

create table Species (
	id INTEGER(11) not null primary key,
	userId VARCHAR(30),
	designation VARCHAR(75) null
);

