/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.grsf.services.jaxrs.resource;

import gr.forth.ics.isl.grsf.services.model.FetchUuidResponseCreationBean;
import gr.forth.ics.isl.grsf.services.model.GrsfRecordBean;
import gr.forth.ics.isl.grsfservicescore.exception.VirtuosoConnectorException;
import gr.forth.ics.isl.grsfservicescore.grsfkb.DatabaseSource;
import gr.forth.ics.isl.grsfservicescore.model.ControlledVocabularies;
import gr.forth.ics.isl.grsfservicescore.triplestore.TripleStoreUpdater;
import gr.forth.ics.isl.grsfservicescore.triplestore.VirtuosoTripleStoreConnector;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.log4j.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@Path(value="/fetch_uuid")
public class RequestFetchUuid {
    private static final Logger log = Logger.getLogger(RequestFetchUuid.class);
    private final TripleStoreUpdater triplestoreUpdater;
    private final DatabaseSource grsfDatabaseSource;
    private final DatabaseSource firmsDatabaseSource;

    public RequestFetchUuid() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("beans.xml");
        this.triplestoreUpdater = new TripleStoreUpdater((VirtuosoTripleStoreConnector)context.getBean("virtuosoConnector", VirtuosoTripleStoreConnector.class));
        this.grsfDatabaseSource = (DatabaseSource)context.getBean("DatabaseSource-GRSF", DatabaseSource.class);
        this.firmsDatabaseSource = (DatabaseSource)context.getBean("DatabaseSource-FIRMS", DatabaseSource.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/stock")
    public Response getRequestStock(@QueryParam(value="id") String firmsID) {
        log.info((Object)("Received incoming fetch_uuid request for stocks with parameter ID: " + firmsID));
        FetchUuidResponseCreationBean responseBean = new FetchUuidResponseCreationBean();
        Response.Status status = Response.Status.OK;
        if (firmsID == null) {
            responseBean.prepareErrorResponse("The values for the parameter 'id' is missing. The parameter is mandatory.");
            status = Response.Status.BAD_REQUEST;
        } else {
            try {
                Collection results = this.triplestoreUpdater.fetchFirmsUUID(firmsID, ControlledVocabularies.ResourceType.STOCK, Arrays.asList(this.firmsDatabaseSource.getSourceGraphSpace(), this.grsfDatabaseSource.getSourceGraphSpace()));
                if (results.isEmpty()) {
                    responseBean.prepareErrorResponse("No stock records were found from FIRMS with ID " + firmsID);
                    status = Response.Status.BAD_REQUEST;
                } else {
                    for (Triple result : results) {
                        GrsfRecordBean grsfRecordBean = new GrsfRecordBean();
                        grsfRecordBean.setFirmsId(firmsID);
                        grsfRecordBean.setGrsfUuid((String)result.getLeft());
                        grsfRecordBean.setGrsfName((String)result.getMiddle());
                        grsfRecordBean.setGrsfSemanticId((String)result.getRight());
                        grsfRecordBean.setRecordType(ControlledVocabularies.ResourceType.STOCK);
                        responseBean.addResult(grsfRecordBean);
                    }
                }
            }
            catch (VirtuosoConnectorException ex) {
                log.error((Object)"An error occured while retrieving the GRSF UUID of stock records coming from FIRMS", (Throwable)ex);
                responseBean.prepareErrorResponse("An error occured while retrieving the GRSF UUID of stock records coming from FIRMS " + firmsID);
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        log.info((Object)("Info Status/Response: " + status + " / " + responseBean));
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/fishery")
    public Response getRequestFishery(@QueryParam(value="id") String firmsID) {
        log.info((Object)("Received incoming fetch_uuid request for fisheries with parameter ID: " + firmsID));
        FetchUuidResponseCreationBean responseBean = new FetchUuidResponseCreationBean();
        Response.Status status = Response.Status.OK;
        if (firmsID == null) {
            responseBean.prepareErrorResponse("The values for the parameter 'id' is missing. The parameter is mandatory.");
            status = Response.Status.BAD_REQUEST;
        } else {
            try {
                Collection results = this.triplestoreUpdater.fetchFirmsUUID(firmsID, ControlledVocabularies.ResourceType.FISHERY, Arrays.asList(this.firmsDatabaseSource.getSourceGraphSpace(), this.grsfDatabaseSource.getSourceGraphSpace()));
                if (results.isEmpty()) {
                    responseBean.prepareErrorResponse("No fishery records were found from FIRMS with ID " + firmsID);
                    status = Response.Status.BAD_REQUEST;
                } else {
                    for (Triple result : results) {
                        GrsfRecordBean grsfRecordBean = new GrsfRecordBean();
                        grsfRecordBean.setFirmsId(firmsID);
                        grsfRecordBean.setGrsfUuid((String)result.getLeft());
                        grsfRecordBean.setGrsfName((String)result.getMiddle());
                        grsfRecordBean.setGrsfSemanticId((String)result.getRight());
                        grsfRecordBean.setRecordType(ControlledVocabularies.ResourceType.FISHERY);
                        responseBean.addResult(grsfRecordBean);
                    }
                }
            }
            catch (VirtuosoConnectorException ex) {
                log.error((Object)"An error occured while retrieving the GRSF UUID of fisheries records coming from FIRMS", (Throwable)ex);
                responseBean.prepareErrorResponse("An error occured while retrieving the GRSF UUID of fisheries records coming from FIRMS " + firmsID);
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        log.info((Object)("Info Status/Response: " + status + " / " + responseBean));
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

