/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.grsfsapi.request;

import gr.forth.ics.isl.grsfsapi.common.Utils;
import gr.forth.ics.isl.grsfsapi.model.ErrorBean;
import gr.forth.ics.isl.grsfsapi.model.HelpBean;
import gr.forth.ics.isl.grsfsapi.model.HelpCollectionBean;
import gr.forth.ics.isl.grsfsapi.model.ResponseFormatType;
import gr.forth.ics.isl.grsfsapi.model.StocksBean;
import gr.forth.ics.isl.grsfsapi.request.StockRequest;
import gr.forth.ics.isl.grsfservicescore.exception.VirtuosoConnectorException;
import gr.forth.ics.isl.grsfservicescore.grsfkb.DatabaseSource;
import gr.forth.ics.isl.grsfservicescore.model.ControlledVocabularies;
import gr.forth.ics.isl.grsfservicescore.triplestore.TripleStoreUpdater;
import gr.forth.ics.isl.grsfservicescore.triplestore.VirtuosoTripleStoreConnector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@Path(value="stocks")
public class StockRequest {
    private static final Logger log = Logger.getLogger(StockRequest.class);
    private final TripleStoreUpdater triplestoreApi;
    private final List<DatabaseSource> namedgraphs;

    public StockRequest() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("beans.xml");
        this.triplestoreApi = new TripleStoreUpdater((VirtuosoTripleStoreConnector)context.getBean("virtuosoConnector", VirtuosoTripleStoreConnector.class));
        this.namedgraphs = (List)context.getBean("namedgraphs-list", ArrayList.class);
    }

    @GET
    @Produces(value={"application/json", "application/xml", "text/html", "text/csv", "text/n3"})
    @Path(value="/")
    public Response getRequest(@QueryParam(value="from_year") String fromYear, @QueryParam(value="before_year") String beforeYear, @QueryParam(value="after_year") String afterYear, @QueryParam(value="from_source") String fromSource, @QueryParam(value="help") String help, @QueryParam(value="response_type") String responseType, @Context UriInfo uriInfo, @HeaderParam(value="Accept") String acceptHeader) {
        log.info((Object)("Received incoming request for stocks with parameters:  fromYear: " + fromYear + ", beforeYear: " + beforeYear + ", afterYear: " + afterYear + ", fromSource: " + fromSource + ", help: " + (help != null) + ", responseType: " + responseType + ", uri context info: " + uriInfo.getQueryParameters() + ", Accept Header Value: " + acceptHeader));
        ResponseFormatType responseFormatType = Utils.getResponseFormatType((String)responseType, (String)acceptHeader);
        Collection<Object> responseBean = new HashSet();
        Response.Status status = Response.Status.OK;
        if (help != null) {
            log.info((Object)"Help menu requested");
            HelpBean helpBean = Utils.createHelpContentsForStocksEndpoint();
            HashSet<HelpBean> helpBeanAsCollection = new HashSet<HelpBean>();
            helpBeanAsCollection.add(helpBean);
            if (responseFormatType == ResponseFormatType.XML) {
                log.debug((Object)"Return values in XML format");
                HelpCollectionBean helpCollection = new HelpCollectionBean();
                helpCollection.setHelpBeans(helpBeanAsCollection);
                return Response.status((Response.Status)status).type("application/xml").entity((Object)helpCollection).build();
            }
            log.debug((Object)"Return values in JSON format");
            return Response.status((Response.Status)status).type("application/json").entity((Object)helpBean).build();
        }
        try {
            ErrorBean errorBean = Utils.validateQueryParameters(Arrays.asList("from_year", "before_year", "after_year", "from_source", "response_type"), (Collection)uriInfo.getQueryParameters().keySet());
            if (errorBean == null && fromSource != null) {
                errorBean = Utils.validateDatabaseSource((String)fromSource);
            }
            if (errorBean != null) {
                log.error((Object)("Wrong query parameters were given: " + errorBean.getErrorMessage()));
                status = Response.Status.NOT_FOUND;
                return Response.status((Response.Status)status).entity((Object)errorBean).build();
            }
            responseBean = this.triplestoreApi.retrieveStockBasicInformation(Utils.normalizeParameter((String)fromYear), Utils.normalizeParameter((String)beforeYear), Utils.normalizeParameter((String)afterYear), this.namedgraphs.stream().map(DatabaseSource::getSourceGraphSpace).collect(Collectors.toList())).values();
            if (fromSource != null) {
                ControlledVocabularies.Source selectedSource = ControlledVocabularies.getDatabaseSource((String)fromSource);
                log.debug((Object)("filter results using database source " + selectedSource));
                log.debug((Object)("Size of unfiltered results: " + responseBean.size()));
                responseBean = responseBean.stream().filter(stockBean -> stockBean.getDatabaseSources().contains(selectedSource)).collect(Collectors.toList());
                log.debug((Object)("Size of filtered results: " + responseBean.size()));
            }
        }
        catch (VirtuosoConnectorException ex) {
            log.error((Object)"An error occured while retrieving stocks from the KB", (Throwable)ex);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        log.info((Object)("Info Status/Response Size: " + status + " / " + responseBean.size()));
        switch (1.$SwitchMap$gr$forth$ics$isl$grsfsapi$model$ResponseFormatType[responseFormatType.ordinal()]) {
            case 1: {
                log.debug((Object)"Return values in XML format");
                StocksBean retStocksData = new StocksBean();
                retStocksData.setStockData(responseBean);
                return Response.status((Response.Status)status).type("application/xml").entity((Object)retStocksData).build();
            }
            case 2: {
                log.debug((Object)"Return values in HTML format");
                return Response.status((Response.Status)status).type("text/html").entity((Object)Utils.generateHtmlContents(responseBean, (Collection)this.getParametersAsCollections(fromYear, beforeYear, afterYear, fromSource))).build();
            }
            case 3: {
                log.debug((Object)"Return values in CSV format");
                return Response.status((Response.Status)status).type("text/csv").entity((Object)Utils.generateCsvContents(responseBean)).header("Content-Disposition", (Object)"attachment; filename=\"stockResults.csv\"").build();
            }
            case 4: 
            case 5: {
                log.debug((Object)"Return values in N3 format");
                return Response.status((Response.Status)status).type("text/n3").entity((Object)Utils.generateN3Contens(responseBean)).header("Content-Disposition", (Object)"attachment; filename=\"stockResults.n3\"").build();
            }
        }
        log.debug((Object)"Return values in JSON format");
        return Response.status((Response.Status)status).type("application/json").entity(responseBean).build();
    }

    private Collection<Pair<String, String>> getParametersAsCollections(String fromYear, String beforeYear, String afterYear, String fromSource) {
        HashSet<Pair<String, String>> retCollection = new HashSet<Pair<String, String>>();
        if (fromYear != null) {
            retCollection.add(Pair.of((Object)"from_year", (Object)fromYear));
        }
        if (beforeYear != null) {
            retCollection.add(Pair.of((Object)"before_year", (Object)beforeYear));
        }
        if (afterYear != null) {
            retCollection.add((Pair<String, String>)Pair.of((Object)"after_year", (Object)afterYear));
        }
        if (fromSource != null) {
            retCollection.add((Pair<String, String>)Pair.of((Object)"from_source", (Object)fromSource));
        }
        return retCollection;
    }
}

