/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.grsfsapi.request;

import gr.forth.ics.isl.grsfsapi.common.Resources;
import gr.forth.ics.isl.grsfsapi.common.Utils;
import gr.forth.ics.isl.grsfsapi.model.ErrorBean;
import gr.forth.ics.isl.grsfsapi.model.HelpBean;
import gr.forth.ics.isl.grsfsapi.model.HelpCollectionBean;
import gr.forth.ics.isl.grsfsapi.model.ResponseFormatType;
import gr.forth.ics.isl.grsfsapi.model.StocksDataBean;
import gr.forth.ics.isl.grsfsapi.request.StockDataRequest;
import gr.forth.ics.isl.grsfservicescore.exception.VirtuosoConnectorException;
import gr.forth.ics.isl.grsfservicescore.grsfkb.DatabaseSource;
import gr.forth.ics.isl.grsfservicescore.triplestore.TripleStoreUpdater;
import gr.forth.ics.isl.grsfservicescore.triplestore.VirtuosoTripleStoreConnector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@Path(value="stock_data")
public class StockDataRequest {
    private static final Logger log = Logger.getLogger(StockDataRequest.class);
    private final TripleStoreUpdater triplestoreApi;
    private final List<DatabaseSource> namedgraphs;

    public StockDataRequest() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("beans.xml");
        this.triplestoreApi = new TripleStoreUpdater((VirtuosoTripleStoreConnector)context.getBean("virtuosoConnector", VirtuosoTripleStoreConnector.class));
        this.namedgraphs = (List)context.getBean("namedgraphs-list", ArrayList.class);
    }

    @GET
    @Produces(value={"application/json", "application/xml", "text/html", "text/csv", "text/n3"})
    @Path(value="/")
    public Response getRequest(@QueryParam(value="uuid") String uuid, @QueryParam(value="type") String type, @QueryParam(value="help") String help, @QueryParam(value="response_type") String responseType, @Context UriInfo uriInfo, @HeaderParam(value="Accept") String acceptHeader) {
        log.info((Object)("Received incoming request for stock data with parameters:  uuid: " + uuid + ", type: " + type + ", help: " + (help != null) + ", responseType: " + responseType + ", uri context info: " + uriInfo.getQueryParameters() + ", Accept Header Value: " + acceptHeader));
        ResponseFormatType responseFormatType = Utils.getResponseFormatType((String)responseType, (String)acceptHeader);
        Collection responseBean = new HashSet();
        Response.Status status = Response.Status.OK;
        if (help != null) {
            log.info((Object)"Help menu requested");
            HelpBean helpBean = Utils.createHelpContentsForStockDataEndpoint();
            HashSet<HelpBean> helpBeanAsCollection = new HashSet<HelpBean>();
            helpBeanAsCollection.add(helpBean);
            if (responseFormatType == ResponseFormatType.XML) {
                log.debug((Object)"Return values in XML format");
                HelpCollectionBean helpCollection = new HelpCollectionBean();
                helpCollection.setHelpBeans(helpBeanAsCollection);
                return Response.status((Response.Status)status).type("application/xml").entity((Object)helpCollection).build();
            }
            log.debug((Object)"Return values in JSON format");
            return Response.status((Response.Status)status).type("application/json").entity((Object)helpBean).build();
        }
        try {
            ErrorBean errorBean = Utils.validateQueryParameters(Arrays.asList("uuid", "type", "response_type"), (Collection)uriInfo.getQueryParameters().keySet());
            if (errorBean == null && uuid == null) {
                errorBean = new ErrorBean("The UUID of the stock is missing. UUID is a mandatory parameter.");
            }
            if (errorBean == null && type != null) {
                errorBean = Utils.validateTimeseriesTypes((String)type);
            }
            if (errorBean != null) {
                log.error((Object)("Wrong query parameters were given: " + errorBean.getErrorMessage()));
                status = Response.Status.NOT_FOUND;
                return Response.status((Response.Status)status).entity((Object)errorBean).build();
            }
            responseBean = this.triplestoreApi.retrieveStockDetailedInformation(Utils.normalizeParameter((String)uuid), Utils.normalizeTimeSeries((String)type), this.namedgraphs.stream().map(DatabaseSource::getSourceGraphSpace).collect(Collectors.toList()));
        }
        catch (VirtuosoConnectorException ex) {
            log.error((Object)"An error occured while retrieving stocks from the KB", (Throwable)ex);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        log.info((Object)("Info Status/Response Size: " + status + " / " + responseBean.size()));
        switch (1.$SwitchMap$gr$forth$ics$isl$grsfsapi$model$ResponseFormatType[responseFormatType.ordinal()]) {
            case 1: {
                log.debug((Object)"Return values in XML format");
                StocksDataBean retStocksData = new StocksDataBean();
                retStocksData.setStockData(responseBean);
                return Response.status((Response.Status)status).type("application/xml").entity((Object)retStocksData).build();
            }
            case 2: {
                log.debug((Object)"Return values in HTML format");
                return Response.status((Response.Status)status).type("text/html").entity((Object)Utils.generateHtmlContents(responseBean, (String)uuid, (Collection)this.getParametersAsCollections(uuid, type))).build();
            }
            case 3: {
                log.debug((Object)"Return values in CSV format");
                return Response.status((Response.Status)status).type("text/csv").entity((Object)Utils.generateCsvTimeseries(responseBean)).header("Content-Disposition", (Object)Resources.getNameForTimeseries((String)"attachment; filename=\"timeseries.csv\"", (String)uuid)).build();
            }
            case 4: 
            case 5: {
                log.debug((Object)"Return values in N3 format");
                return Response.status((Response.Status)status).type("text/n3").entity((Object)Utils.generateN3Timeseries(responseBean)).header("Content-Disposition", (Object)Resources.getNameForTimeseries((String)"attachment; filename=\"timeseries.n3\"", (String)uuid)).build();
            }
        }
        log.debug((Object)"Return values in JSON format");
        return Response.status((Response.Status)status).type("application/json").entity(responseBean).build();
    }

    private Collection<Pair<String, String>> getParametersAsCollections(String uuid, String typesConcat) {
        HashSet<Pair<String, String>> retCollection = new HashSet<Pair<String, String>>();
        if (uuid != null) {
            retCollection.add((Pair<String, String>)Pair.of((Object)"uuid", (Object)uuid));
        }
        if (typesConcat != null) {
            retCollection.add((Pair<String, String>)Pair.of((Object)"type", (Object)typesConcat));
        }
        return retCollection;
    }
}

