/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.grsfsapi.common;

import gr.forth.ics.isl.grsfsapi.common.Resources;
import gr.forth.ics.isl.grsfsapi.model.ErrorBean;
import gr.forth.ics.isl.grsfsapi.model.HelpBean;
import gr.forth.ics.isl.grsfsapi.model.ParameterBean;
import gr.forth.ics.isl.grsfsapi.model.ResponseFormatType;
import gr.forth.ics.isl.grsfservicescore.model.beans.StockBean;
import gr.forth.ics.isl.grsfservicescore.model.beans.StockData;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    private static final Logger log = Logger.getLogger(Utils.class);

    public static ErrorBean validateQueryParameters(Collection<String> expectedParameters, Collection<String> receivedParameters) {
        for (String incomingParameter : receivedParameters) {
            if (expectedParameters.stream().anyMatch(param -> param.equalsIgnoreCase(incomingParameter))) continue;
            return new ErrorBean("The query parameter \"" + incomingParameter + "\" is uknown. Only the following query parameters are accepted: " + expectedParameters);
        }
        return null;
    }

    public static ErrorBean validateTimeseriesTypes(String timeseriesTypesConact) {
        HashSet<String> erroneousTypes = new HashSet<String>();
        if (timeseriesTypesConact != null) {
            String[] timeseriesParameterArray;
            for (String originalParamTerm : timeseriesParameterArray = timeseriesTypesConact.split(",")) {
                if (!Resources.TIMESERIES_TYPES.stream().noneMatch(type -> type.equalsIgnoreCase(originalParamTerm))) continue;
                erroneousTypes.add(originalParamTerm);
            }
        }
        if (!erroneousTypes.isEmpty()) {
            return new ErrorBean("The following timeseries types are invalid: " + erroneousTypes + ". The following timeseries types are supported: " + Resources.TIMESERIES_TYPES);
        }
        return null;
    }

    public static ErrorBean validateDatabaseSource(String databaseSourceParam) {
        if (databaseSourceParam != null && Resources.DATABASE_SOURCES.stream().noneMatch(type -> type.equalsIgnoreCase(databaseSourceParam))) {
            return new ErrorBean("The given database source [" + databaseSourceParam + "] is invalid.Only the following database sources are allowed: " + Resources.DATABASE_SOURCES);
        }
        return null;
    }

    public static String normalizeParameter(String originalParameter) {
        return originalParameter == null ? "" : originalParameter;
    }

    public static Collection<String> normalizeTimeSeries(String originalParameter) {
        HashSet<String> retCollection = new HashSet<String>();
        if (originalParameter != null) {
            String[] originalParametersArray;
            for (String originalParamTerm : originalParametersArray = originalParameter.split(",")) {
                String normalizedTimeSeriesTerm = Utils.retrieveNormalizedTimeSeriesTerm((String)originalParamTerm);
                if (normalizedTimeSeriesTerm == null) continue;
                retCollection.add(normalizedTimeSeriesTerm);
            }
        }
        return retCollection;
    }

    private static String retrieveNormalizedTimeSeriesTerm(String originalTimeSeriesTerm) {
        if (originalTimeSeriesTerm.equalsIgnoreCase("abundlevel")) {
            return "Abundance Level";
        }
        if (originalTimeSeriesTerm.equalsIgnoreCase("abundlevelstd")) {
            return "Abundance Level - Standard";
        }
        if (originalTimeSeriesTerm.equalsIgnoreCase("biomass")) {
            return "Biomass";
        }
        if (originalTimeSeriesTerm.equalsIgnoreCase("catches")) {
            return "Catches";
        }
        if (originalTimeSeriesTerm.equalsIgnoreCase("landings")) {
            return "Landing";
        }
        if (originalTimeSeriesTerm.equalsIgnoreCase("fishingpres")) {
            return "Fishing Pressure";
        }
        if (originalTimeSeriesTerm.equalsIgnoreCase("fishingpresstd")) {
            return "Fishing Pressure - Standard";
        }
        return null;
    }

    public static HelpBean createHelpContentsForStocksEndpoint() {
        HelpBean helpBean = new HelpBean();
        helpBean.setEndpoint("/stocks");
        helpBean.setDescription("The method searches for stocks in the GRSF Knowledge Base that have associated timeseries");
        helpBean.setResponseContentTypes(Arrays.asList("application/json", "application/xml"));
        helpBean.addParameter(new ParameterBean("from_year", "number", "Retrieves only the stock records for which there is at least one time series with reporting year equals to the given year value", false, Arrays.asList(new String[0]), "2018"));
        helpBean.addParameter(new ParameterBean("before_year", "number", "Retrieves only the stock records for which there is at least one time series with reporting year before the given year value", false, Arrays.asList(new String[0]), "2010"));
        helpBean.addParameter(new ParameterBean("after_year", "number", "Retrieves only the stock records for which there is at least one time series with reporting year after the given year value", false, Arrays.asList(new String[0]), "2015"));
        helpBean.addParameter(new ParameterBean("from_source", "string", "The name of the source database that provided this record", false, Arrays.asList("firms", "ram", "fishsource"), "firms"));
        return helpBean;
    }

    public static HelpBean createHelpContentsForStockDataEndpoint() {
        HelpBean helpBean = new HelpBean();
        helpBean.setEndpoint("/stock_data");
        helpBean.setDescription("The method searches for time-series of a particular stock record");
        helpBean.setResponseContentTypes(Arrays.asList("application/json", "application/xml"));
        helpBean.addParameter(new ParameterBean("uuid", "string", "the UUID of the stock", false, Arrays.asList(new String[0]), "04a54e36-0f12-30db-a102-db24e3566f4b"));
        helpBean.addParameter(new ParameterBean("type", "string", "comma-separated list of the types of the time-series to search for", true, Arrays.asList("catches", "landings", "abundlevel", "abundlevelstd", "fishingpres", "fishingpresstd"), "catches,landings"));
        return helpBean;
    }

    public static String generateHtmlContents(Collection<StockBean> stockBeans, Collection<Pair<String, String>> parameters) {
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<html><title> Results ").append("</title><body><h2> Stock Results ").append("</h2>").append("<hr>").append("<h4>Parameters</h4>");
        if (parameters.isEmpty()) {
            htmlBuilder.append("No parameters were given");
        } else {
            htmlBuilder.append("<table border=\"2\">");
            for (Pair<String, String> parameterPair : parameters) {
                htmlBuilder.append("<tr><td>").append((String)parameterPair.getLeft()).append("</td><td>").append((String)parameterPair.getRight()).append("</td></tr>");
            }
            htmlBuilder.append("</table>");
        }
        htmlBuilder.append("<hr><div align=\"right\"><i>show results in: </i>").append("<a href=\"").append(Utils.generateSuffix((String)"stocks", parameters, (ResponseFormatType)ResponseFormatType.JSON)).append("\" target=\"_blank\"> ").append(ResponseFormatType.JSON).append("</a> &nbsp;").append("<a href=\"").append(Utils.generateSuffix((String)"stocks", parameters, (ResponseFormatType)ResponseFormatType.XML)).append("\" target=\"_blank\"> ").append(ResponseFormatType.XML).append("</a> &nbsp;").append("<a href=\"").append(Utils.generateSuffix((String)"stocks", parameters, (ResponseFormatType)ResponseFormatType.CSV)).append("\" target=\"_blank\"> ").append(ResponseFormatType.CSV).append("</a> &nbsp;").append("<a href=\"").append(Utils.generateSuffix((String)"stocks", parameters, (ResponseFormatType)ResponseFormatType.N3)).append("\" target=\"_blank\"> ").append(ResponseFormatType.N3).append("</a> &nbsp;").append("</div>").append("<h3>Number of results: ").append(stockBeans.size()).append("</h3><br><table border=\"1\"><tr>").append("<th>UUID</th><th>Name</th><th>Semantic ID</th><th>Type</th><th>Status</th><th>Database Sources</th><th>Reporting Years</th><th>URL</th>").append("</tr>");
        stockBeans.forEach(stockBean -> htmlBuilder.append(stockBean.toHtml(false, "stock_data?uuid=")));
        htmlBuilder.append("</table>").append(Utils.generateHtmlFooter()).append("</body></html>");
        return htmlBuilder.toString();
    }

    public static String generateHtmlContents(Collection<StockData> stockData, String stockUUID, Collection<Pair<String, String>> parameters) {
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<html><title> Results ").append("</title><body><h2> Stock Timeseries ").append("<hr>").append("<h4>Parameters</h4>");
        if (parameters.isEmpty()) {
            htmlBuilder.append("No parameters were given");
        } else {
            htmlBuilder.append("<table border=\"2\">");
            for (Pair<String, String> parameterPair : parameters) {
                htmlBuilder.append("<tr><td>").append(((String)parameterPair.getLeft()).equalsIgnoreCase("type") ? "types" : (String)parameterPair.getLeft()).append("</td><td>").append(((String)parameterPair.getLeft()).equalsIgnoreCase("type") ? Utils.normalizeTimeSeries((String)((String)parameterPair.getRight())).toString() : (String)parameterPair.getRight()).append("</td></tr>");
            }
            htmlBuilder.append("</table>");
        }
        htmlBuilder.append("<hr><div align=\"right\"><i>show results in: </i>").append("<a href=\"").append(Utils.generateSuffix((String)"stock_data", parameters, (ResponseFormatType)ResponseFormatType.JSON)).append("\" target=\"_blank\"> ").append(ResponseFormatType.JSON).append("</a> &nbsp;").append("<a href=\"").append(Utils.generateSuffix((String)"stock_data", parameters, (ResponseFormatType)ResponseFormatType.XML)).append("\" target=\"_blank\"> ").append(ResponseFormatType.XML).append("</a> &nbsp;").append("<a href=\"").append(Utils.generateSuffix((String)"stock_data", parameters, (ResponseFormatType)ResponseFormatType.CSV)).append("\" target=\"_blank\"> ").append(ResponseFormatType.CSV).append("</a> &nbsp;").append("<a href=\"").append(Utils.generateSuffix((String)"stock_data", parameters, (ResponseFormatType)ResponseFormatType.N3)).append("\" target=\"_blank\"> ").append(ResponseFormatType.N3).append("</a> &nbsp;").append("</div>");
        htmlBuilder.append("<h3> Number of results: ").append(stockData.size()).append("</h3><br>").append("<table border=\"1\"><tr>").append("<th>Type</th><th>Value</th><th>Unit</th><th>Reference Year</th><th>Reporting Year</th><th>Data Owner</th><th>Database Source</th>").append("</tr>");
        stockData.forEach(stockDataEntry -> htmlBuilder.append(stockDataEntry.toHtml(false)));
        htmlBuilder.append("</table>").append(Utils.generateHtmlFooter()).append("</body></html>");
        return htmlBuilder.toString();
    }

    private static String generateHtmlFooter() {
        StringBuilder htmlFooterBuilder = new StringBuilder();
        SimpleDateFormat dateFormatGmt = new SimpleDateFormat("MMMM dd yyyy, HH:mm:ss zzz");
        dateFormatGmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        htmlFooterBuilder.append("<hr>").append("<footer>").append("<i>automatically generated on: ").append(dateFormatGmt.format(new Date())).append("</i></footer>");
        return htmlFooterBuilder.toString();
    }

    public static String generateCsvContents(Collection<StockBean> stockBeans) {
        StringBuilder csvBuilder = new StringBuilder();
        csvBuilder.append("UUID,Name,Semantic ID,Type,Status,Database Sources,Reporting Years,URL").append("\n");
        stockBeans.forEach(stockBean -> csvBuilder.append(stockBean.toCSV(false)).append("\n"));
        return csvBuilder.toString();
    }

    public static String generateCsvTimeseries(Collection<StockData> stockDataCollection) {
        StringBuilder csvBuilder = new StringBuilder();
        csvBuilder.append("Type,Value,Unit,Reference Year,Reporting Year,Data Owner,Database Source").append("\n");
        stockDataCollection.forEach(stockData -> csvBuilder.append(stockData.toCSV(false)).append("\n"));
        return csvBuilder.toString();
    }

    public static String generateN3Contens(Collection<StockBean> stockBeans) {
        StringBuilder n3Builder = new StringBuilder();
        stockBeans.forEach(stockBean -> n3Builder.append(stockBean.toNtriples(Utils.generateRandomUrn())));
        return n3Builder.toString();
    }

    public static String generateN3Timeseries(Collection<StockData> stockDataCollection) {
        StringBuilder n3Builder = new StringBuilder();
        stockDataCollection.forEach(stockData -> {
            int index = 1;
            n3Builder.append(stockData.toNtriples(Utils.generateRandomUrn(), index++));
        });
        return n3Builder.toString();
    }

    public static ResponseFormatType getResponseFormatType(String responseParameter, String acceptHeader) {
        log.debug((Object)("Identifying response type using responseParameter: " + responseParameter + " and acceptHeader" + acceptHeader));
        ResponseFormatType retType = ResponseFormatType.JSON;
        if (responseParameter != null) {
            try {
                retType = ResponseFormatType.valueOf((String)responseParameter.trim().toUpperCase());
                log.debug((Object)("Return type: " + retType));
                return retType;
            }
            catch (IllegalArgumentException ex) {
                log.debug((Object)("Cannot identify the proper response type with text value " + responseParameter));
            }
        }
        if (acceptHeader != null) {
            if (acceptHeader.equalsIgnoreCase("application/json")) {
                return ResponseFormatType.JSON;
            }
            if (acceptHeader.equalsIgnoreCase("application/xml")) {
                return ResponseFormatType.XML;
            }
            if (acceptHeader.toLowerCase().contains("text/html".toLowerCase())) {
                return ResponseFormatType.HTML;
            }
            if (acceptHeader.contains("text/csv")) {
                return ResponseFormatType.CSV;
            }
            log.debug((Object)("Cannot identify the proper response type for the accept header with mime type " + acceptHeader));
        }
        log.debug((Object)("Return the DEFAULT response format type " + retType));
        return retType;
    }

    public static String generateRandomUrn() {
        return "urn:uuid:" + UUID.randomUUID().toString();
    }

    private static String generateSuffix(String endpoint, Collection<Pair<String, String>> parameters, ResponseFormatType responseFormat) {
        StringBuilder suffixBuilder = new StringBuilder();
        suffixBuilder.append(endpoint).append("?");
        for (Pair<String, String> parameterPair : parameters) {
            if (((String)parameterPair.getLeft()).equalsIgnoreCase("response_type")) continue;
            suffixBuilder.append((String)parameterPair.getLeft()).append("=").append((String)parameterPair.getRight()).append("&");
        }
        suffixBuilder.append("response_type").append("=").append(responseFormat.toString());
        return suffixBuilder.toString();
    }
}

