/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.repo.auth.webapp.inject.servlets;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.util.Modules;
import com.sun.jersey.guice.JerseyServletModule;
import gr.cite.repo.auth.app.config.SamlSecurityConfiguration;
import gr.cite.repo.auth.app.utils.LocationResolver;
import gr.cite.repo.auth.app.utils.UrlLocationResolver;
import gr.cite.repo.auth.webapp.inject.modules.SamlSecureServletModule;
import gr.cite.repo.auth.webapp.inject.modules.SimpleServletModule;
import io.dropwizard.configuration.ConfigurationFactory;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.FileConfigurationSourceProvider;
import io.dropwizard.jackson.Jackson;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Validation;
import javax.validation.Validator;

public abstract class SamlSecureServletConfig<T extends SamlSecurityConfiguration>
extends GuiceServletContextListener {
    private T configuration;
    private Module defaultModule = new AbstractModule(){

        protected void configure() {
            this.bind(LocationResolver.class).to(UrlLocationResolver.class);
        }
    };

    protected abstract Class<T> getClazz();

    protected abstract String getConfiguationFilePath();

    protected abstract List<Module> getModules();

    protected abstract String getName();

    protected Injector getInjector() {
        JerseyServletModule servletModule = this.isSecure() != false ? new SamlSecureServletModule((SamlSecurityConfiguration)((Object)this.getConfiguration())) : new SimpleServletModule();
        ArrayList allModules = Lists.newArrayList((Object[])new Module[]{servletModule});
        allModules.addAll(this.getModules());
        return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{this.defaultModule}).with((Iterable)allModules)});
    }

    public T getConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.getConf(this.getConfiguationFilePath(), this.getClazz());
            this.configuration.getLoggingFactory().configure(new MetricRegistry(), this.getName());
        }
        return this.configuration;
    }

    protected Boolean isSecure() {
        return ((SamlSecurityConfiguration)((Object)this.getConfiguration())).getSecurity() != null;
    }

    T getConf(String path, Class<T> klass) {
        FileConfigurationSourceProvider provider = new FileConfigurationSourceProvider();
        String propertyPrefix = "dw";
        ObjectMapper objectMapper = Jackson.newObjectMapper();
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        ConfigurationFactory factory = new ConfigurationFactory(klass, validator, objectMapper, propertyPrefix);
        SamlSecurityConfiguration configuration = null;
        try {
            configuration = (SamlSecurityConfiguration)((Object)factory.build((ConfigurationSourceProvider)provider, path));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return (T)((Object)configuration);
    }
}

