/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gos.resources;

import gr.cite.clustermanager.DataCreator;
import gr.cite.clustermanager.DataMonitor;
import gr.cite.gaap.datatransferobjects.TaxonomyTermMessenger;
import gr.cite.gaap.datatransferobjects.layeroperations.NameTaxonomyPair;
import gr.cite.gaap.datatransferobjects.layeroperations.ShapeBoundaryRequest;
import gr.cite.gaap.datatransferobjects.layeroperations.TaxonomyTermAttributePair;
import gr.cite.gaap.servicelayer.EnvironmentInitializer;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.exception.GeoServerBridgeException;
import gr.cite.geoanalytics.logicallayer.LayerOperations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Path(value="/")
@Component
public class GeoServerResource {
    private DataMonitor dataMonitor;
    private DataCreator dataCreator;
    private LayerOperations layerOperations;
    private EnvironmentInitializer environmentInitializer;

    public GeoServerResource(DataMonitor dataMonitor, DataCreator dataCreator, LayerOperations layerOperations, EnvironmentInitializer enviromentEnvironmentInitializer) throws Exception {
        this.dataMonitor = dataMonitor;
        this.dataCreator = dataCreator;
        this.layerOperations = layerOperations;
        this.environmentInitializer = enviromentEnvironmentInitializer;
    }

    @PostConstruct
    private void createZnodeData() throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        executorService.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"application/json"})
    public Response getGeoserverData(@PathParam(value="name") String name) throws IOException, GeoServerBridgeException {
        Set geoservers = (Set)this.dataMonitor.getLayerKeyData().get(name);
        String data = null;
        if (geoservers != null) {
            data = (String)new ArrayList(geoservers).get((int)(Math.random() * 10.0) * geoservers.size() / 10);
        }
        return Response.status((int)200).entity(data).build();
    }

    @POST
    @Path(value="getShapesOfTerm")
    @Produces(value={"application/json"})
    public Response getShapesOfTerm(NameTaxonomyPair nameTaxonomyPair) {
        List shapeMessengers = new ArrayList();
        try {
            shapeMessengers = this.layerOperations.getShapesOfTerm(nameTaxonomyPair.termName, nameTaxonomyPair.termTaxonomy);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(shapeMessengers).build();
    }

    @POST
    @Path(value="findTermMappingsOfLayerShapes")
    @Produces(value={"application/json"})
    public Response findTermMappingsOfLayerShapes(TaxonomyTermMessenger layerTerm) {
        List taxonomyTermShapeMessengers = new ArrayList();
        try {
            taxonomyTermShapeMessengers = this.layerOperations.findTermMappingsOfLayerShapes(layerTerm);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(taxonomyTermShapeMessengers).build();
    }

    @POST
    @Path(value="getAttributeValuesOfShapesByTerm")
    @Produces(value={"application/json"})
    public Response getAttributeValuesOfShapesByTerm(TaxonomyTermAttributePair taxonomyTermAttributePair) {
        Set attributeValuesOfShapeByTerm = new HashSet();
        try {
            attributeValuesOfShapeByTerm = this.layerOperations.getAttributeValuesOfShapesByTerm(taxonomyTermAttributePair.getLayerTerm(), taxonomyTermAttributePair.getAttr());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(attributeValuesOfShapeByTerm).build();
    }

    @POST
    @Path(value="getShapeInfoForTerm")
    @Produces(value={"application/json"})
    public Response getShapeOfTerm(NameTaxonomyPair nameTaxonomyPair) {
        List ShapeInfoMessengers = new ArrayList();
        try {
            ShapeInfoMessengers = this.layerOperations.getShapeInfoForTerm(nameTaxonomyPair.getTermName(), nameTaxonomyPair.getTermTaxonomy());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(ShapeInfoMessengers).build();
    }

    @POST
    @Path(value="generateShapeBoundary")
    @Produces(value={"application/json"})
    public Response getShapeOfTerm(ShapeBoundaryRequest shapeBoundaryRequesst) {
        try {
            this.layerOperations.generateShapeBoundary(shapeBoundaryRequesst.getLayerTerm(), shapeBoundaryRequesst.getBoundaryTerm(), shapeBoundaryRequesst.getUserMessenger());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    static /* synthetic */ EnvironmentInitializer access$000(GeoServerResource x0) {
        return x0.environmentInitializer;
    }

    static /* synthetic */ DataCreator access$100(GeoServerResource x0) {
        return x0.dataCreator;
    }
}

